/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.model.AbstractModel;
import opennlp.model.DataIndexer;
import opennlp.model.EventStream;
import opennlp.model.MaxentModel;
import opennlp.model.SequenceStream;
import opennlp.model.TrainUtil;
import opennlp.model.TwoPassDataIndexer;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameFinderEventStream;
import opennlp.tools.namefind.NameFinderSequenceValidator;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleSequenceStream;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.BeamSearch;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AdditionalContextFeatureGenerator;
import opennlp.tools.util.featuregen.BigramNameFeatureGenerator;
import opennlp.tools.util.featuregen.CachedFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.featuregen.GeneratorFactory;
import opennlp.tools.util.featuregen.OutcomePriorFeatureGenerator;
import opennlp.tools.util.featuregen.PreviousMapFeatureGenerator;
import opennlp.tools.util.featuregen.SentenceFeatureGenerator;
import opennlp.tools.util.featuregen.TokenClassFeatureGenerator;
import opennlp.tools.util.featuregen.TokenFeatureGenerator;
import opennlp.tools.util.featuregen.WindowFeatureGenerator;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameFinderME
implements TokenNameFinder {
    private static String[][] EMPTY = new String[0][0];
    public static final int DEFAULT_BEAM_SIZE = 3;
    private static final Pattern typedOutcomePattern = Pattern.compile("(.+)-\\w+");
    public static final String START = "start";
    public static final String CONTINUE = "cont";
    public static final String OTHER = "other";
    protected MaxentModel model;
    protected NameContextGenerator contextGenerator;
    private Sequence bestSequence;
    private BeamSearch<String> beam;
    private AdditionalContextFeatureGenerator additionalContextFeatureGenerator = new AdditionalContextFeatureGenerator();

    public NameFinderME(TokenNameFinderModel model) {
        this(model, 3);
    }

    public NameFinderME(TokenNameFinderModel model, AdaptiveFeatureGenerator generator, int beamSize, SequenceValidator<String> sequenceValidator) {
        this.model = model.getNameFinderModel();
        if (generator != null) {
            this.contextGenerator = new DefaultNameContextGenerator(generator);
        } else {
            AdaptiveFeatureGenerator featureGenerator = model.createFeatureGenerators();
            if (featureGenerator == null) {
                featureGenerator = NameFinderME.createFeatureGenerator();
            }
            this.contextGenerator = new DefaultNameContextGenerator(featureGenerator);
        }
        this.contextGenerator.addFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)this.additionalContextFeatureGenerator, 8, 8));
        if (sequenceValidator == null) {
            sequenceValidator = new NameFinderSequenceValidator();
        }
        this.beam = new BeamSearch<String>(beamSize, this.contextGenerator, this.model, sequenceValidator, beamSize);
    }

    public NameFinderME(TokenNameFinderModel model, AdaptiveFeatureGenerator generator, int beamSize) {
        this(model, generator, beamSize, null);
    }

    public NameFinderME(TokenNameFinderModel model, int beamSize) {
        this(model, null, beamSize);
    }

    @Deprecated
    public NameFinderME(MaxentModel mod) {
        this(mod, new DefaultNameContextGenerator(), 3);
    }

    @Deprecated
    public NameFinderME(MaxentModel mod, NameContextGenerator cg) {
        this(mod, cg, 3);
    }

    @Deprecated
    public NameFinderME(MaxentModel mod, NameContextGenerator cg, int beamSize) {
        this.model = mod;
        this.contextGenerator = cg;
        this.contextGenerator.addFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)this.additionalContextFeatureGenerator, 8, 8));
        this.beam = new BeamSearch<String>(beamSize, cg, mod, new NameFinderSequenceValidator(), beamSize);
    }

    private static AdaptiveFeatureGenerator createFeatureGenerator() {
        return new CachedFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)new TokenFeatureGenerator(), 2, 2), new WindowFeatureGenerator((AdaptiveFeatureGenerator)new TokenClassFeatureGenerator(true), 2, 2), new OutcomePriorFeatureGenerator(), new PreviousMapFeatureGenerator(), new BigramNameFeatureGenerator(), new SentenceFeatureGenerator(true, false));
    }

    private static AdaptiveFeatureGenerator createFeatureGenerator(byte[] generatorDescriptor, final Map<String, Object> resources) throws IOException {
        AdaptiveFeatureGenerator featureGenerator = generatorDescriptor != null ? GeneratorFactory.create(new ByteArrayInputStream(generatorDescriptor), new FeatureGeneratorResourceProvider(){

            public Object getResource(String key) {
                if (resources != null) {
                    return resources.get(key);
                }
                return null;
            }
        }) : null;
        return featureGenerator;
    }

    @Override
    public Span[] find(String[] tokens) {
        return this.find(tokens, EMPTY);
    }

    public Span[] find(String[] tokens, String[][] additionalContext) {
        this.additionalContextFeatureGenerator.setCurrentContext(additionalContext);
        this.bestSequence = this.beam.bestSequence((String[])tokens, (Object[])additionalContext);
        List<String> c = this.bestSequence.getOutcomes();
        this.contextGenerator.updateAdaptiveData(tokens, c.toArray(new String[c.size()]));
        int start = -1;
        int end = -1;
        ArrayList<Span> spans = new ArrayList<Span>(tokens.length);
        for (int li = 0; li < c.size(); ++li) {
            String chunkTag = c.get(li);
            if (chunkTag.endsWith(START)) {
                if (start != -1) {
                    spans.add(new Span(start, end, NameFinderME.extractNameType(c.get(li - 1))));
                }
                start = li;
                end = li + 1;
                continue;
            }
            if (chunkTag.endsWith(CONTINUE)) {
                end = li + 1;
                continue;
            }
            if (!chunkTag.endsWith(OTHER) || start == -1) continue;
            spans.add(new Span(start, end, NameFinderME.extractNameType(c.get(li - 1))));
            start = -1;
            end = -1;
        }
        if (start != -1) {
            spans.add(new Span(start, end, NameFinderME.extractNameType(c.get(c.size() - 1))));
        }
        return spans.toArray(new Span[spans.size()]);
    }

    @Override
    public void clearAdaptiveData() {
        this.contextGenerator.clearAdaptiveData();
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    public double[] probs(Span[] spans) {
        double[] sprobs = new double[spans.length];
        double[] probs = this.bestSequence.getProbs();
        for (int si = 0; si < spans.length; ++si) {
            double p = 0.0;
            for (int oi = spans[si].getStart(); oi < spans[si].getEnd(); ++oi) {
                p += probs[oi];
            }
            sprobs[si] = p /= (double)spans[si].length();
        }
        return sprobs;
    }

    public static TokenNameFinderModel train(String languageCode, String type, ObjectStream<NameSample> samples, TrainingParameters trainParams, AdaptiveFeatureGenerator generator, Map<String, Object> resources) throws IOException {
        AbstractModel nameFinderModel;
        if (languageCode == null) {
            throw new IllegalArgumentException("languageCode must not be null!");
        }
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        AdaptiveFeatureGenerator featureGenerator = generator != null ? generator : NameFinderME.createFeatureGenerator();
        if (!TrainUtil.isSequenceTraining(trainParams.getSettings())) {
            NameFinderEventStream eventStream = new NameFinderEventStream(samples, type, new DefaultNameContextGenerator(featureGenerator));
            nameFinderModel = TrainUtil.train((EventStream)eventStream, trainParams.getSettings(), manifestInfoEntries);
        } else {
            NameSampleSequenceStream ss = new NameSampleSequenceStream(samples, featureGenerator);
            nameFinderModel = TrainUtil.train((SequenceStream)ss, trainParams.getSettings(), manifestInfoEntries);
        }
        return new TokenNameFinderModel(languageCode, nameFinderModel, resources, manifestInfoEntries);
    }

    public static TokenNameFinderModel train(String languageCode, String type, ObjectStream<NameSample> samples, TrainingParameters trainParams, byte[] featureGeneratorBytes, Map<String, Object> resources) throws IOException {
        TokenNameFinderModel model = NameFinderME.train(languageCode, type, samples, trainParams, NameFinderME.createFeatureGenerator(featureGeneratorBytes, resources), resources);
        if (featureGeneratorBytes != null) {
            model = model.updateFeatureGenerator(featureGeneratorBytes);
        }
        return model;
    }

    public static TokenNameFinderModel train(String languageCode, String type, ObjectStream<NameSample> samples, AdaptiveFeatureGenerator generator, Map<String, Object> resources, int iterations, int cutoff) throws IOException {
        return NameFinderME.train(languageCode, type, samples, ModelUtil.createTrainingParameters(iterations, cutoff), generator, resources);
    }

    @Deprecated
    public static TokenNameFinderModel train(String languageCode, String type, ObjectStream<NameSample> samples, Map<String, Object> resources, int iterations, int cutoff) throws IOException {
        return NameFinderME.train(languageCode, type, samples, (AdaptiveFeatureGenerator)null, resources, iterations, cutoff);
    }

    public static TokenNameFinderModel train(String languageCode, String type, ObjectStream<NameSample> samples, Map<String, Object> resources) throws IOException {
        return NameFinderME.train(languageCode, type, samples, resources, 100, 5);
    }

    @Deprecated
    public static TokenNameFinderModel train(String languageCode, String type, ObjectStream<NameSample> samples, byte[] generatorDescriptor, Map<String, Object> resources, int iterations, int cutoff) throws IOException {
        AdaptiveFeatureGenerator featureGenerator = NameFinderME.createFeatureGenerator(generatorDescriptor, resources);
        TokenNameFinderModel model = NameFinderME.train(languageCode, type, samples, featureGenerator, resources, iterations, cutoff);
        if (generatorDescriptor != null) {
            model = model.updateFeatureGenerator(generatorDescriptor);
        }
        return model;
    }

    @Deprecated
    public static GISModel train(EventStream es, int iterations, int cut) throws IOException {
        return GIS.trainModel((int)iterations, (DataIndexer)new TwoPassDataIndexer(es, cut));
    }

    static final String extractNameType(String outcome) {
        Matcher matcher = typedOutcomePattern.matcher(outcome);
        if (matcher.matches()) {
            String nameType = matcher.group(1);
            return nameType;
        }
        return null;
    }

    public static Span[] dropOverlappingSpans(Span[] spans) {
        ArrayList sortedSpans = new ArrayList(spans.length);
        Collections.addAll(sortedSpans, spans);
        Collections.sort(sortedSpans);
        Iterator it = sortedSpans.iterator();
        Span lastSpan = null;
        while (it.hasNext()) {
            Span span = (Span)it.next();
            if (lastSpan != null && lastSpan.intersects(span)) {
                it.remove();
                span = lastSpan;
            }
            lastSpan = span;
        }
        return sortedSpans.toArray(new Span[sortedSpans.size()]);
    }
}

