/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.leipzig;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

public class LeipzigLanguageSampleStream
implements ObjectStream<LanguageSample> {
    private final int sentencesPerSample;
    private Map<String, Integer> langSampleCounts;
    private File[] sentencesFiles;
    private Iterator<File> sentencesFilesIt;
    private ObjectStream<LanguageSample> sampleStream;
    private final Random random;

    public LeipzigLanguageSampleStream(File leipzigFolder, int sentencesPerSample, int samplesPerLanguage) throws IOException {
        this.sentencesPerSample = sentencesPerSample;
        this.sentencesFiles = leipzigFolder.listFiles();
        Arrays.sort(this.sentencesFiles);
        Map<String, Integer> langCounts = Arrays.stream(this.sentencesFiles).map(file -> file.getName().substring(0, 3)).collect(Collectors.groupingBy(String::toString, Collectors.summingInt(v -> 1)));
        this.langSampleCounts = langCounts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> samplesPerLanguage / (Integer)e.getValue()));
        this.random = new Random(23L);
        this.reset();
    }

    @Override
    public LanguageSample read() throws IOException {
        LanguageSample sample;
        if (this.sampleStream != null && (sample = this.sampleStream.read()) != null) {
            return sample;
        }
        if (this.sentencesFilesIt.hasNext()) {
            File sentencesFile = this.sentencesFilesIt.next();
            String lang = sentencesFile.getName().substring(0, 3);
            this.sampleStream = new LeipzigSentencesStream(lang, sentencesFile, this.sentencesPerSample, this.langSampleCounts.get(lang));
            return this.read();
        }
        return null;
    }

    @Override
    public void reset() throws IOException {
        this.sentencesFilesIt = Arrays.asList(this.sentencesFiles).iterator();
        this.sampleStream = null;
    }

    private class LeipzigSentencesStream
    implements ObjectStream<LanguageSample> {
        private final String lang;
        private Iterator<String> lineIterator;

        LeipzigSentencesStream(String lang, File sentencesFile, int sentencesPerSample, int numberOfSamples) throws IOException {
            this.lang = lang;
            int totalLineCount = (int)Files.lines(sentencesFile.toPath()).count();
            List indexes = IntStream.range(0, totalLineCount).boxed().collect(Collectors.toList());
            Collections.shuffle(indexes, LeipzigLanguageSampleStream.this.random);
            HashSet selectedLines = new HashSet(indexes.subList(0, sentencesPerSample * numberOfSamples));
            ArrayList<String> sentences = new ArrayList<String>();
            try (PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStreamFactory)new MarkableFileInputStreamFactory(sentencesFile), StandardCharsets.UTF_8);){
                String line;
                int lineIndex = 0;
                while ((line = (String)lineStream.read()) != null) {
                    int tabIndex = line.indexOf(9);
                    if (tabIndex != -1 && selectedLines.contains(lineIndex)) {
                        sentences.add(line);
                    }
                    ++lineIndex;
                }
            }
            Collections.shuffle(sentences, LeipzigLanguageSampleStream.this.random);
            this.lineIterator = sentences.iterator();
        }

        @Override
        public LanguageSample read() throws IOException {
            StringBuilder sampleString = new StringBuilder();
            for (int count = 0; count < LeipzigLanguageSampleStream.this.sentencesPerSample && this.lineIterator.hasNext(); ++count) {
                String line = this.lineIterator.next();
                int textStart = line.indexOf(9) + 1;
                sampleString.append(line.substring(textStart) + " ");
            }
            if (sampleString.length() > 0) {
                return new LanguageSample(new Language(this.lang), sampleString);
            }
            return null;
        }
    }
}

