/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.tokenize.TokenContextGenerator;
import opennlp.tools.tokenize.lang.Factory;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ext.ExtensionLoader;

public class TokenizerFactory
extends BaseToolFactory {
    private String languageCode;
    private Dictionary abbreviationDictionary;
    private Boolean useAlphaNumericOptimization = false;
    private Pattern alphaNumericPattern;
    private static final String ABBREVIATIONS_ENTRY_NAME = "abbreviations.dictionary";
    private static final String USE_ALPHA_NUMERIC_OPTIMIZATION = "useAlphaNumericOptimization";
    private static final String ALPHA_NUMERIC_PATTERN = "alphaNumericPattern";

    public TokenizerFactory() {
    }

    public TokenizerFactory(String languageCode, Dictionary abbreviationDictionary, boolean useAlphaNumericOptimization, Pattern alphaNumericPattern) {
        this.init(languageCode, abbreviationDictionary, useAlphaNumericOptimization, alphaNumericPattern);
    }

    protected void init(String languageCode, Dictionary abbreviationDictionary, boolean useAlphaNumericOptimization, Pattern alphaNumericPattern) {
        this.languageCode = languageCode;
        this.useAlphaNumericOptimization = useAlphaNumericOptimization;
        this.alphaNumericPattern = alphaNumericPattern;
        this.abbreviationDictionary = abbreviationDictionary;
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
        if (this.artifactProvider.getManifestProperty(USE_ALPHA_NUMERIC_OPTIMIZATION) == null) {
            throw new InvalidFormatException("useAlphaNumericOptimization is a mandatory property!");
        }
        Object abbreviationsEntry = this.artifactProvider.getArtifact(ABBREVIATIONS_ENTRY_NAME);
        if (abbreviationsEntry != null && !(abbreviationsEntry instanceof Dictionary)) {
            throw new InvalidFormatException("Abbreviations dictionary '" + abbreviationsEntry + "' has wrong type, needs to be of type Dictionary!");
        }
    }

    @Override
    public Map<String, Object> createArtifactMap() {
        Map<String, Object> artifactMap = super.createArtifactMap();
        if (this.abbreviationDictionary != null) {
            artifactMap.put(ABBREVIATIONS_ENTRY_NAME, this.abbreviationDictionary);
        }
        return artifactMap;
    }

    @Override
    public Map<String, String> createManifestEntries() {
        Map<String, String> manifestEntries = super.createManifestEntries();
        manifestEntries.put(USE_ALPHA_NUMERIC_OPTIMIZATION, Boolean.toString(this.isUseAlphaNumericOptimization()));
        if (this.getAlphaNumericPattern() != null) {
            manifestEntries.put(ALPHA_NUMERIC_PATTERN, this.getAlphaNumericPattern().pattern());
        }
        return manifestEntries;
    }

    public static TokenizerFactory create(String subclassName, String languageCode, Dictionary abbreviationDictionary, boolean useAlphaNumericOptimization, Pattern alphaNumericPattern) throws InvalidFormatException {
        if (subclassName == null) {
            return new TokenizerFactory(languageCode, abbreviationDictionary, useAlphaNumericOptimization, alphaNumericPattern);
        }
        try {
            TokenizerFactory theFactory = ExtensionLoader.instantiateExtension(TokenizerFactory.class, subclassName);
            theFactory.init(languageCode, abbreviationDictionary, useAlphaNumericOptimization, alphaNumericPattern);
            return theFactory;
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
            System.err.println(msg);
            e.printStackTrace();
            throw new InvalidFormatException(msg, e);
        }
    }

    public Pattern getAlphaNumericPattern() {
        if (this.alphaNumericPattern == null) {
            String prop;
            if (this.artifactProvider != null && (prop = this.artifactProvider.getManifestProperty(ALPHA_NUMERIC_PATTERN)) != null) {
                this.alphaNumericPattern = Pattern.compile(prop);
            }
            if (this.alphaNumericPattern == null) {
                Factory f = new Factory();
                this.alphaNumericPattern = f.getAlphanumeric(this.languageCode);
            }
        }
        return this.alphaNumericPattern;
    }

    public boolean isUseAlphaNumericOptimization() {
        if (this.artifactProvider != null) {
            this.useAlphaNumericOptimization = Boolean.valueOf(this.artifactProvider.getManifestProperty(USE_ALPHA_NUMERIC_OPTIMIZATION));
        }
        return this.useAlphaNumericOptimization;
    }

    public Dictionary getAbbreviationDictionary() {
        if (this.abbreviationDictionary == null && this.artifactProvider != null) {
            this.abbreviationDictionary = (Dictionary)this.artifactProvider.getArtifact(ABBREVIATIONS_ENTRY_NAME);
        }
        return this.abbreviationDictionary;
    }

    public String getLanguageCode() {
        if (this.languageCode == null && this.artifactProvider != null) {
            this.languageCode = this.artifactProvider.getLanguage();
        }
        return this.languageCode;
    }

    public TokenContextGenerator getContextGenerator() {
        Factory f = new Factory();
        Dictionary abbDict = this.getAbbreviationDictionary();
        Set<String> abbs = abbDict != null ? abbDict.asStringSet() : Collections.emptySet();
        return f.createTokenContextGenerator(this.getLanguageCode(), abbs);
    }
}

