/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.ext;

import java.lang.reflect.Field;
import opennlp.tools.commons.Internal;
import opennlp.tools.util.ext.ExtensionNotLoadedException;

@Internal
public class ExtensionLoader {
    private ExtensionLoader() {
    }

    public static <T> T instantiateExtension(Class<T> clazz, String extensionClassName) {
        try {
            Class<?> extClazz = Class.forName(extensionClassName);
            if (clazz.isAssignableFrom(extClazz)) {
                try {
                    return (T)extClazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new ExtensionNotLoadedException(e);
                }
                catch (IllegalAccessException e) {
                    Field instanceField;
                    try {
                        instanceField = extClazz.getDeclaredField("INSTANCE");
                    }
                    catch (NoSuchFieldException | SecurityException e1) {
                        throw new ExtensionNotLoadedException(e1);
                    }
                    if (instanceField != null) {
                        try {
                            return (T)instanceField.get(null);
                        }
                        catch (IllegalAccessException | IllegalArgumentException e1) {
                            throw new ExtensionNotLoadedException(e1);
                        }
                    }
                    throw new ExtensionNotLoadedException(e);
                }
            }
            throw new ExtensionNotLoadedException("Extension class '" + extClazz.getName() + "' needs to have type: " + clazz.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExtensionNotLoadedException("Unable to find implementation for " + clazz.getName() + ", the class or service " + extensionClassName + " could not be located!");
        }
    }
}

