/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32C;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import opennlp.tools.ml.model.AbstractDataIndexer;
import opennlp.tools.ml.model.ComparableEvent;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.ObjectStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoPassDataIndexer
extends AbstractDataIndexer {
    private static final Logger logger = LoggerFactory.getLogger(TwoPassDataIndexer.class);

    @Override
    public void index(ObjectStream<Event> eventStream) throws IOException {
        long readChecksum;
        List<ComparableEvent> eventsToCompare;
        long writeChecksum;
        int cutoff = this.trainingParameters.getIntParameter("Cutoff", 5);
        boolean sort = this.trainingParameters.getBooleanParameter("sort", true);
        logger.info("Indexing events with TwoPass using cutoff of {}", (Object)cutoff);
        logger.info("Computing event counts...");
        long start = System.currentTimeMillis();
        HashMap<String, Integer> predicateIndex = new HashMap<String, Integer>();
        File tmp = Files.createTempFile("events", null, new FileAttribute[0]).toFile();
        tmp.deleteOnExit();
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
             CheckedOutputStream writeStream = new CheckedOutputStream(out, new CRC32C());
             DataOutputStream dos = new DataOutputStream(writeStream);){
            int numEvents = this.computeEventCounts(eventStream, dos, predicateIndex, cutoff);
            writeChecksum = writeStream.getChecksum().getValue();
            logger.info("done. {} events", (Object)numEvents);
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(tmp));
             CheckedInputStream readStream = new CheckedInputStream(in, new CRC32C());
             EventStream readEventsStream = new EventStream(new DataInputStream(readStream));){
            logger.info("Indexing...");
            eventsToCompare = this.index(readEventsStream, predicateIndex);
            readChecksum = readStream.getChecksum().getValue();
        }
        tmp.delete();
        if (readChecksum != writeChecksum) {
            throw new IOException("Checksum for writing and reading events did not match.");
        }
        logger.info("done.");
        if (sort) {
            logger.info("Sorting and merging events... ");
        } else {
            logger.info("Collecting events... ");
        }
        this.sortAndMerge(eventsToCompare, sort);
        logger.info(String.format("Done indexing in %.2f s.", (double)(System.currentTimeMillis() - start) / 1000.0));
    }

    /*
     * WARNING - void declaration
     */
    private int computeEventCounts(ObjectStream<Event> eventStream, DataOutputStream eventStore, Map<String, Integer> predicatesInOut, int cutoff) throws IOException {
        void var9_13;
        Event ev;
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        int eventCount = 0;
        while ((ev = eventStream.read()) != null) {
            ++eventCount;
            eventStore.writeUTF(ev.getOutcome());
            eventStore.writeInt(ev.getContext().length);
            String[] ec = ev.getContext();
            TwoPassDataIndexer.update(ec, counter);
            for (String ctxString : ec) {
                eventStore.writeUTF(ctxString);
            }
            if (ev.getValues() == null) {
                eventStore.writeInt(0);
                continue;
            }
            eventStore.writeInt(ev.getValues().length);
            for (float value : ev.getValues()) {
                eventStore.writeFloat(value);
            }
        }
        String[] predicateSet = (String[])counter.entrySet().stream().filter(entry -> (Integer)entry.getValue() >= cutoff).map(Map.Entry::getKey).sorted().toArray(String[]::new);
        this.predCounts = new int[predicateSet.length];
        boolean bl = false;
        while (var9_13 < predicateSet.length) {
            this.predCounts[var9_13] = (Integer)counter.get(predicateSet[var9_13]);
            predicatesInOut.put(predicateSet[var9_13], (int)var9_13);
            ++var9_13;
        }
        return eventCount;
    }

    private static class EventStream
    implements ObjectStream<Event> {
        private final DataInputStream inputStream;

        public EventStream(DataInputStream dataInputStream) {
            this.inputStream = dataInputStream;
        }

        @Override
        public Event read() throws IOException {
            if (this.inputStream.available() != 0) {
                String outcome = this.inputStream.readUTF();
                int contextLength = this.inputStream.readInt();
                String[] context = new String[contextLength];
                for (int i = 0; i < contextLength; ++i) {
                    context[i] = this.inputStream.readUTF();
                }
                int valuesLength = this.inputStream.readInt();
                float[] values = null;
                if (valuesLength > 0) {
                    values = new float[valuesLength];
                    for (int i = 0; i < valuesLength; ++i) {
                        values[i] = this.inputStream.readFloat();
                    }
                }
                return new Event(outcome, context, values);
            }
            return null;
        }

        @Override
        public void reset() throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }
    }
}

