/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.inject.spi.ProducerFactory;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.util.WebBeansUtil;

public class AbstractProducerBean<T>
extends AbstractOwbBean<T>
implements PassivationCapable {
    private Class<T> returnType;
    private Producer<T> producer;

    public AbstractProducerBean(Class<?> ownerBeanClass, WebBeansContext webBeansContext, WebBeansType webBeansType, BeanAttributes<T> beanAttributes, Class<T> returnType, ProducerFactory<?> producerFactory) {
        super(webBeansContext, webBeansType, beanAttributes, ownerBeanClass, !returnType.isPrimitive());
        this.returnType = returnType;
        this.producer = producerFactory.createProducer((Bean)this);
    }

    @Override
    public Producer<T> getProducer() {
        return this.producer;
    }

    @Override
    public Class<T> getReturnType() {
        return this.returnType;
    }

    public void dispose(T instance, CreationalContext<T> creationalContext) {
    }

    protected void checkNullInstance(Object instance, String producerName) {
        String errorMessage = "WebBeans producer : %s return type in the component implementation class : %s scope type must be @Dependent to create null instance";
        WebBeansUtil.checkNullInstance(instance, this.getScope(), errorMessage, producerName, this.getBeanClass().getName());
    }

    protected void checkScopeType(String producerName) {
        String errorMessage = "WebBeans producer : %s return type in the component implementation class : %s with passivating scope @%s must be Serializable";
        this.getWebBeansContext().getWebBeansUtil().checkSerializableScopeType(this.getScope(), Serializable.class.isAssignableFrom(this.getReturnType()), errorMessage, producerName, this.getBeanClass().getName(), this.getScope().getName());
    }

    protected boolean isPassivationCapable(Class<?> returnType, Integer modifiers) {
        if (Modifier.isFinal(modifiers) && !Serializable.class.isAssignableFrom(returnType)) {
            return false;
        }
        return returnType.isPrimitive() || Serializable.class.isAssignableFrom(returnType);
    }
}

