/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.enterprise.inject.spi.ProducerFactory;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.FieldProducerFactory;
import org.apache.webbeans.component.creation.MethodProducerFactory;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.InjectionTargetFactoryImpl;
import org.apache.webbeans.util.AnnotationUtil;

public abstract class AbstractBeanManager
implements BeanManager {
    protected abstract WebBeansContext getWebBeansContext();

    public boolean areInterceptorBindingsEquivalent(Annotation annotation1, Annotation annotation2) {
        return AnnotationUtil.isCdiAnnotationEqual(annotation1, annotation2);
    }

    public boolean areQualifiersEquivalent(Annotation annotation1, Annotation annotation2) {
        return AnnotationUtil.isCdiAnnotationEqual(annotation1, annotation2);
    }

    public int getInterceptorBindingHashCode(Annotation annotation) {
        return AnnotationUtil.getCdiAnnotationHashCode(annotation);
    }

    public int getQualifierHashCode(Annotation annotation) {
        return AnnotationUtil.getCdiAnnotationHashCode(annotation);
    }

    public <T> BeanAttributes<T> createBeanAttributes(AnnotatedType<T> type) {
        return BeanAttributesBuilder.forContext(this.getWebBeansContext()).newBeanAttibutes(type).build();
    }

    public BeanAttributes<?> createBeanAttributes(AnnotatedMember<?> member) {
        if (member instanceof AnnotatedField) {
            return BeanAttributesBuilder.forContext(this.getWebBeansContext()).newBeanAttibutes((AnnotatedField)member).build();
        }
        if (member instanceof AnnotatedMethod) {
            return BeanAttributesBuilder.forContext(this.getWebBeansContext()).newBeanAttibutes((AnnotatedMethod)member).build();
        }
        throw new IllegalArgumentException("Unsupported member type " + member.getClass().getName());
    }

    public InjectionPoint createInjectionPoint(AnnotatedField<?> field) {
        return this.getWebBeansContext().getInjectionPointFactory().buildInjectionPoint(null, field);
    }

    public InjectionPoint createInjectionPoint(AnnotatedParameter<?> parameter) {
        return this.getWebBeansContext().getInjectionPointFactory().buildInjectionPoint(null, parameter);
    }

    public <X> ProducerFactory<X> getProducerFactory(AnnotatedField<? super X> field, Bean<X> bean) {
        return new FieldProducerFactory<X>(field, bean, this.getWebBeansContext());
    }

    public <X> ProducerFactory<X> getProducerFactory(AnnotatedMethod<? super X> method, Bean<X> bean) {
        return new MethodProducerFactory<X>(method, bean, this.getWebBeansContext());
    }

    public <X> InjectionTargetFactory<X> getInjectionTargetFactory(AnnotatedType<X> type) {
        return new InjectionTargetFactoryImpl<X>(type, this.getWebBeansContext());
    }

    public <T> Bean<T> createBean(BeanAttributes<T> attributes, Class<T> type, InjectionTargetFactory<T> factory) {
        return new InjectionTargetBean<T>(this.getWebBeansContext(), WebBeansType.THIRDPARTY, this.getWebBeansContext().getAnnotatedElementFactory().newAnnotatedType(type), attributes, type, factory);
    }

    public <T, X> Bean<T> createBean(BeanAttributes<T> attributes, Class<X> type, ProducerFactory<X> factory) {
        return null;
    }

    public <T extends Extension> T getExtension(Class<T> type) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

