/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;

public final class SerializableBean<T>
implements Bean<T>,
PassivationCapable,
Serializable {
    private static final long serialVersionUID = -8141263188006177021L;
    private Bean<T> bean;

    public Bean<T> getBean() {
        return this.bean;
    }

    SerializableBean(Bean<T> bean) {
        this.bean = bean;
    }

    public Set<Type> getTypes() {
        return this.bean.getTypes();
    }

    public Set<Annotation> getQualifiers() {
        return this.bean.getQualifiers();
    }

    public Class<? extends Annotation> getScope() {
        return this.bean.getScope();
    }

    public String getName() {
        return this.bean.getName();
    }

    public boolean isNullable() {
        return this.bean.isNullable();
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.bean.getInjectionPoints();
    }

    public Class<?> getBeanClass() {
        return this.bean.getBeanClass();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.bean.getStereotypes();
    }

    public boolean isAlternative() {
        return this.bean.isAlternative();
    }

    public T create(CreationalContext<T> tCreationalContext) {
        return (T)this.bean.create(tCreationalContext);
    }

    public void destroy(T instance, CreationalContext<T> tCreationalContext) {
        this.bean.destroy(instance, tCreationalContext);
    }

    public String getId() {
        return ((OwbBean)this.bean).getId();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        String id = this.getId();
        if (id == null) {
            throw new NotSerializableException();
        }
        s.writeObject(id);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        String id = (String)s.readObject();
        Object b = WebBeansContext.currentInstance().getBeanManagerImpl().getPassivationCapableBean(id);
        if (b == null) {
            throw new DeploymentException("cannot deserialize Bean with PassivationCapable id=" + id);
        }
        if (b instanceof SerializableBean) {
            b = ((SerializableBean)b).getBean();
        }
        this.bean = b;
    }

    public boolean equals(Object other) {
        if (other instanceof SerializableBean) {
            return this.bean.equals(((SerializableBean)other).getBean());
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.bean.hashCode();
    }
}

