/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.SessionBeanType;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.core.singleton.SingletonContainer;
import org.apache.openejb.core.stateful.StatefulContainer;
import org.apache.openejb.core.stateless.StatelessContainer;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.webbeans.ejb.component.EjbBean;
import org.apache.webbeans.ejb.util.EjbDefinitionUtility;
import org.apache.webbeans.ejb.util.EjbUtility;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.plugins.AbstractOwbPlugin;
import org.apache.webbeans.plugins.OpenWebBeansEjbPlugin;

public class EjbPlugin
extends AbstractOwbPlugin
implements OpenWebBeansEjbPlugin {
    private ContainerSystem containerSystem = null;
    private Map<Class<?>, DeploymentInfo> statelessBeans = new ConcurrentHashMap();
    private Map<Class<?>, DeploymentInfo> statefullBeans = new ConcurrentHashMap();
    private Map<Class<?>, DeploymentInfo> singletonBeans = new ConcurrentHashMap();

    public <T> Bean<T> defineSessionBean(Class<T> clazz) {
        if (!this.isSessionBean(clazz)) {
            throw new IllegalArgumentException("Given class is not an session bean class");
        }
        DeploymentInfo info = null;
        SessionBeanType type = SessionBeanType.STATELESS;
        if (this.isStatelessBean(clazz)) {
            info = this.statelessBeans.get(clazz);
        } else if (this.isStatefulBean(clazz)) {
            info = this.statefullBeans.get(clazz);
            type = SessionBeanType.STATEFUL;
        } else if (this.isSingletonBean(clazz)) {
            info = this.singletonBeans.get(clazz);
            type = SessionBeanType.SINGLETON;
        } else {
            throw new IllegalArgumentException("Illegal EJB type with class : " + clazz.getName());
        }
        EjbBean<T> bean = new EjbBean<T>(clazz);
        bean.setDeploymentInfo(info);
        bean.setEjbType(type);
        EjbUtility.fireEvents(clazz, bean);
        return bean;
    }

    public boolean isSessionBean(Class<?> clazz) {
        if (this.containerSystem == null) {
            Container[] containers;
            this.containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
            for (Container container : containers = this.containerSystem.containers()) {
                DeploymentInfo[] deployments = container.deployments();
                if (container instanceof StatelessContainer) {
                    this.addBeanDeploymentInfos(deployments, SessionBeanType.STATELESS);
                    continue;
                }
                if (container instanceof StatefulContainer) {
                    this.addBeanDeploymentInfos(deployments, SessionBeanType.STATEFUL);
                    continue;
                }
                if (!(container instanceof SingletonContainer)) continue;
                this.addBeanDeploymentInfos(deployments, SessionBeanType.SINGLETON);
            }
        }
        return this.isSingletonBean(clazz) || this.isStatelessBean(clazz) || this.isStatefulBean(clazz);
    }

    private void addBeanDeploymentInfos(DeploymentInfo[] deployments, SessionBeanType type) {
        for (DeploymentInfo deployment : deployments) {
            if (type.equals((Object)SessionBeanType.STATELESS)) {
                this.statelessBeans.put(deployment.getBeanClass(), deployment);
                continue;
            }
            if (type.equals((Object)SessionBeanType.STATEFUL)) {
                this.statefullBeans.put(deployment.getBeanClass(), deployment);
                continue;
            }
            if (!type.equals((Object)SessionBeanType.SINGLETON)) continue;
            this.singletonBeans.put(deployment.getBeanClass(), deployment);
        }
    }

    public void isManagedBean(Class<?> clazz) throws WebBeansConfigurationException {
        if (this.isSessionBean(clazz)) {
            throw new WebBeansConfigurationException("Managed Bean implementation class : " + clazz.getName() + " can not be sesion bean class");
        }
    }

    public boolean isSingletonBean(Class<?> clazz) {
        return this.singletonBeans.containsKey(clazz);
    }

    public boolean isStatefulBean(Class<?> clazz) {
        return this.statefullBeans.containsKey(clazz);
    }

    public boolean isStatelessBean(Class<?> clazz) {
        return this.statelessBeans.containsKey(clazz);
    }

    public Object getSessionBeanProxy(Bean<?> bean, Class<?> iface, CreationalContext<?> creationalContext) {
        return EjbDefinitionUtility.defineEjbBeanProxy((EjbBean)bean, iface, creationalContext);
    }
}

