/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.SessionBeanType;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ivm.EjbHomeProxyHandler;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;

public class OpenEjbBean<T>
extends BaseEjbBean<T> {
    private DeploymentInfo deploymentInfo;

    public OpenEjbBean(Class<T> ejbClassType, SessionBeanType type) {
        super(ejbClassType, type);
    }

    public void setDeploymentInfo(DeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
    }

    public DeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    protected T getInstance(CreationalContext<T> creationalContext) {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        for (Class<?> clazz : this.getBusinessLocalInterfaces()) {
            interfaces.add(clazz);
        }
        DeploymentInfo.BusinessLocalHome home = this.getBusinessLocalHome(interfaces);
        return (T)home.create();
    }

    public String getEjbName() {
        return this.deploymentInfo.getEjbName();
    }

    public List<Class<?>> getBusinessLocalInterfaces() {
        ArrayList clazzes = new ArrayList();
        List cl = this.deploymentInfo.getBusinessLocalInterfaces();
        if (cl != null && !cl.isEmpty()) {
            for (Class c : cl) {
                clazzes.add(c);
            }
        }
        return clazzes;
    }

    public List<Method> getRemoveMethods() {
        return this.deploymentInfo.getRemoveMethods();
    }

    private DeploymentInfo.BusinessLocalHome getBusinessLocalHome(List<Class> interfaces) {
        if (this.getBusinessLocalInterfaces().size() == 0) {
            throw new IllegalStateException("This component has no business local interfaces: " + ((CoreDeploymentInfo)this.deploymentInfo).getDeploymentID());
        }
        if (interfaces.size() == 0) {
            throw new IllegalArgumentException("No interface classes were specified");
        }
        for (Class clazz : interfaces) {
            if (this.getBusinessLocalInterfaces().contains(clazz)) continue;
            throw new IllegalArgumentException("Not a business interface of this bean:" + clazz.getName());
        }
        return (DeploymentInfo.BusinessLocalHome)EjbHomeProxyHandler.createHomeProxy((DeploymentInfo)this.deploymentInfo, (InterfaceType)InterfaceType.BUSINESS_LOCAL_HOME, interfaces);
    }
}

