/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.resource;

import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.assembler.classic.JndiBuilder;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;

public class EJBInstanceProxy<T> {
    private Object deploymentId;
    private DeploymentInfo deploymentInfo;
    private Class<T> intf;

    public EJBInstanceProxy() {
    }

    public EJBInstanceProxy(DeploymentInfo deploymentInfo, Class<T> intf) {
        this.deploymentInfo = deploymentInfo;
        this.intf = intf;
    }

    public Object getDeploymentId() {
        if (this.deploymentId != null) {
            return this.deploymentId;
        }
        if (this.deploymentInfo != null) {
            return this.deploymentInfo.getDeploymentID();
        }
        return null;
    }

    public void setDeploymentId(Object deploymentId) {
        this.deploymentId = deploymentId;
    }

    public DeploymentInfo getDeploymentInfo() {
        if (this.deploymentInfo != null) {
            return this.deploymentInfo;
        }
        if (this.deploymentId != null) {
            ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
            DeploymentInfo deploymentInfo = containerSystem.getDeploymentInfo(this.deploymentId);
            return deploymentInfo;
        }
        return null;
    }

    public void setDeploymentInfo(DeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
    }

    public Class<T> getInterface() {
        return this.intf;
    }

    public void setInterface(Class<T> intf) {
        this.intf = intf;
    }

    public T getObject() throws Exception {
        if (this.intf == null) {
            throw new NullPointerException("intf is null");
        }
        DeploymentInfo deploymentInfo = this.getDeploymentInfo();
        if (deploymentInfo == null) {
            throw new IllegalStateException("DeploymentInfo or DeploymentID must be set before EJB can be retrieved");
        }
        String jndiName = "java:openejb/Deployment/" + JndiBuilder.format((Object)deploymentInfo.getDeploymentID(), (String)this.getInterface().getName());
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        Object proxy = containerSystem.getJNDIContext().lookup(jndiName);
        if (!this.intf.isInstance(proxy)) {
            throw new IllegalArgumentException("EJB at " + jndiName + " is not an instance of " + this.intf.getName() + ", but is " + proxy.getClass().getName());
        }
        return this.intf.cast(proxy);
    }

    public Class<T> getObjectType() {
        return this.getInterface();
    }

    public boolean isSingleton() {
        return false;
    }
}

