/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.spi.BeanAttributes;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.InjectionTargetFactoryImpl;
import org.apache.webbeans.container.InterceptorInjectionTargetFactory;
import org.apache.webbeans.util.CDI11s;
import org.apache.webbeans.util.ExceptionUtil;

public abstract class InterceptorBean<T>
extends InjectionTargetBean<T>
implements Interceptor<T> {
    private Map<InterceptionType, Method[]> interceptionMethods;
    protected Method aroundInvokeMethod = null;
    protected Method aroundConstructMethod = null;

    protected InterceptorBean(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType, BeanAttributes<T> beanAttributes, Class<T> beanClass, Map<InterceptionType, Method[]> interceptionMethods, Method aroundConstruct, InjectionTargetFactoryImpl<T> factory) {
        super(webBeansContext, WebBeansType.INTERCEPTOR, annotatedType, beanAttributes, beanClass, factory);
        Method[] aroundInvokeMethods;
        this.interceptionMethods = Collections.unmodifiableMap(interceptionMethods);
        for (Method[] methods : interceptionMethods.values()) {
            for (Method method : methods) {
                if (method.isAccessible()) continue;
                method.setAccessible(true);
            }
        }
        this.aroundConstructMethod = aroundConstruct;
        if (this.aroundConstructMethod != null && !this.aroundConstructMethod.isAccessible()) {
            this.aroundConstructMethod.setAccessible(true);
        }
        if ((aroundInvokeMethods = interceptionMethods.get(InterceptionType.AROUND_INVOKE)) != null && aroundInvokeMethods.length == 1) {
            this.aroundInvokeMethod = aroundInvokeMethods[0];
        }
    }

    public InterceptorBean(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType, BeanAttributesImpl<T> beanAttributes, Class<T> beanClass, Map<InterceptionType, Method[]> interceptionMethods, Method aroundConstructMethod) {
        this(webBeansContext, annotatedType, beanAttributes, beanClass, interceptionMethods, aroundConstructMethod, new InterceptorInjectionTargetFactory<T>(annotatedType, webBeansContext));
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public Method[] getInterceptorMethods(InterceptionType interceptionType) {
        return this.interceptionMethods.get(interceptionType);
    }

    public boolean intercepts(InterceptionType interceptionType) {
        return this.interceptionMethods.containsKey(interceptionType) || interceptionType.equals((Object)CDI11s.AROUND_CONSTRUCT) && this.aroundConstructMethod != null;
    }

    public Object intercept(InterceptionType interceptionType, T instance, InvocationContext invocationContext) {
        try {
            if (interceptionType.equals((Object)CDI11s.AROUND_CONSTRUCT) && this.aroundConstructMethod != null) {
                return this.aroundConstructMethod.invoke(instance, invocationContext);
            }
            if (InterceptionType.AROUND_INVOKE == interceptionType && this.aroundInvokeMethod != null) {
                return this.aroundInvokeMethod.invoke(instance, invocationContext);
            }
            Method[] interceptorMethods = this.getInterceptorMethods(interceptionType);
            if (interceptorMethods == null || interceptorMethods.length == 0) {
                return invocationContext.proceed();
            }
            if (interceptorMethods.length == 1) {
                if (interceptorMethods[0].getParameterTypes().length == 1) {
                    return interceptorMethods[0].invoke(instance, invocationContext);
                }
                return invocationContext.proceed();
            }
            if (invocationContext instanceof MultiMethodInvocationContext) {
                MultiMethodInvocationContext mmInvocationContext = (MultiMethodInvocationContext)invocationContext;
                int methodIndex = mmInvocationContext.getCurrentInterceptorIdx();
                if (methodIndex < interceptorMethods.length - 1) {
                    return interceptorMethods[methodIndex].invoke(instance, invocationContext);
                }
                return interceptorMethods[methodIndex].invoke(instance, mmInvocationContext.getWrapped());
            }
            MultiMethodInvocationContext mmInvocationContext = new MultiMethodInvocationContext(invocationContext, interceptionType, instance, this);
            return mmInvocationContext.proceed();
        }
        catch (InvocationTargetException ite) {
            throw ExceptionUtil.throwAsRuntimeException(ite.getCause());
        }
        catch (Exception e) {
            throw ExceptionUtil.throwAsRuntimeException(e);
        }
    }

    public static class MultiMethodInvocationContext
    implements InvocationContext {
        private final InvocationContext wrapped;
        private final Interceptor interceptor;
        private final InterceptionType interceptionType;
        private final Object instance;
        private int currentInterceptorIdx;

        public MultiMethodInvocationContext(InvocationContext wrapped, InterceptionType interceptionType, Object instance, Interceptor interceptor) {
            this.wrapped = wrapped;
            this.interceptor = interceptor;
            this.interceptionType = interceptionType;
            this.instance = instance;
            this.currentInterceptorIdx = 0;
        }

        public int getCurrentInterceptorIdx() {
            return this.currentInterceptorIdx - 1;
        }

        public InvocationContext getWrapped() {
            return this.wrapped;
        }

        public Object proceed() throws Exception {
            ++this.currentInterceptorIdx;
            return this.interceptor.intercept(this.interceptionType, this.instance, (InvocationContext)this);
        }

        public Map<String, Object> getContextData() {
            return this.wrapped.getContextData();
        }

        public Method getMethod() {
            return this.wrapped.getMethod();
        }

        public Object getTarget() {
            return this.wrapped.getTarget();
        }

        public Object getTimer() {
            return this.wrapped.getTimer();
        }

        public Object[] getParameters() {
            return this.wrapped.getParameters();
        }

        public void setParameters(Object[] parameters) {
            this.wrapped.setParameters(parameters);
        }

        public Constructor getConstructor() {
            return null;
        }
    }
}

