/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.configurator;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.configurator.AnnotatedConstructorConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedFieldConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.AnnotatedConstructorConfiguratorImpl;
import org.apache.webbeans.configurator.AnnotatedFieldConfiguratorImpl;
import org.apache.webbeans.configurator.AnnotatedMethodConfiguratorImpl;
import org.apache.webbeans.portable.AnnotatedConstructorImpl;
import org.apache.webbeans.portable.AnnotatedFieldImpl;
import org.apache.webbeans.portable.AnnotatedMethodImpl;
import org.apache.webbeans.portable.AnnotatedTypeImpl;

public class AnnotatedTypeConfiguratorImpl<T>
implements AnnotatedTypeConfigurator<T> {
    private final AnnotatedType<T> originalAnnotatedType;
    private final AnnotatedTypeImpl<T> newAnnotatedType;
    private Set<AnnotatedConstructorConfigurator<T>> annotatedConstructorConfigurators;
    private Set<AnnotatedMethodConfigurator<? super T>> annotatedMethodConfigurators;
    private Set<AnnotatedFieldConfigurator<? super T>> annotatedFieldConfigurators;

    public AnnotatedTypeConfiguratorImpl(WebBeansContext webBeansContext, AnnotatedType<T> originalAnnotatedType) {
        this.originalAnnotatedType = originalAnnotatedType;
        this.newAnnotatedType = new AnnotatedTypeImpl(webBeansContext, originalAnnotatedType);
        this.annotatedConstructorConfigurators = this.newAnnotatedType.getConstructors().stream().map(m -> new AnnotatedConstructorConfiguratorImpl((AnnotatedConstructorImpl)m)).collect(Collectors.toSet());
        this.annotatedMethodConfigurators = this.newAnnotatedType.getMethods().stream().map(m -> new AnnotatedMethodConfiguratorImpl((AnnotatedMethodImpl)m)).collect(Collectors.toSet());
        this.annotatedFieldConfigurators = this.newAnnotatedType.getFields().stream().map(m -> new AnnotatedFieldConfiguratorImpl((AnnotatedFieldImpl)m)).collect(Collectors.toSet());
    }

    public AnnotatedType<T> getAnnotated() {
        return this.originalAnnotatedType;
    }

    public AnnotatedTypeConfigurator<T> add(Annotation annotation) {
        this.newAnnotatedType.addAnnotation(annotation);
        return this;
    }

    public AnnotatedTypeConfigurator<T> remove(Predicate predicate) {
        this.newAnnotatedType.getAnnotations().removeIf(predicate);
        return this;
    }

    public AnnotatedTypeConfigurator<T> removeAll() {
        this.newAnnotatedType.clearAnnotations();
        return this;
    }

    public Set<AnnotatedMethodConfigurator<? super T>> methods() {
        return this.annotatedMethodConfigurators;
    }

    public Set<AnnotatedFieldConfigurator<? super T>> fields() {
        return this.annotatedFieldConfigurators;
    }

    public Set<AnnotatedConstructorConfigurator<T>> constructors() {
        return this.annotatedConstructorConfigurators;
    }

    public AnnotatedTypeImpl<T> getNewAnnotatedType() {
        return this.newAnnotatedType;
    }
}

