/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi.se;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BusyConversationException;
import javax.enterprise.context.ContextException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NonexistentConversationException;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.inject.Singleton;
import org.apache.webbeans.annotation.BeforeDestroyedLiteral;
import org.apache.webbeans.annotation.DestroyedLiteral;
import org.apache.webbeans.annotation.InitializedLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.AbstractContextsService;
import org.apache.webbeans.context.ApplicationContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.DependentContext;
import org.apache.webbeans.context.RequestContext;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.intercept.RequestScopedBeanInterceptorHandler;
import org.apache.webbeans.intercept.SessionScopedBeanInterceptorHandler;

public abstract class BaseSeContextsService
extends AbstractContextsService {
    private static ThreadLocal<RequestContext> requestContext = new ThreadLocal();
    private static ThreadLocal<SessionContext> sessionContext = new ThreadLocal();
    private static ThreadLocal<ConversationContext> conversationContext = new ThreadLocal();
    private static ThreadLocal<DependentContext> dependentContext = new ThreadLocal();
    private ApplicationContext applicationContext;

    protected BaseSeContextsService(WebBeansContext webBeansContext) {
        super(webBeansContext);
    }

    protected abstract void destroySingletonContext();

    protected abstract Context getCurrentSingletonContext();

    protected abstract void createSingletonContext();

    @Override
    public void endContext(Class<? extends Annotation> scopeType, Object endParameters) {
        if (scopeType.equals(RequestScoped.class)) {
            this.stopRequestContext();
        } else if (scopeType.equals(SessionScoped.class)) {
            this.stopSessionContext();
        } else if (scopeType.equals(ApplicationScoped.class)) {
            this.stopApplicationContext();
        } else if (scopeType.equals(ConversationScoped.class)) {
            this.stopConversationContext();
        } else if (scopeType.equals(Singleton.class)) {
            this.stopSingletonContext();
        }
    }

    @Override
    public Context getCurrentContext(Class<? extends Annotation> scopeType) {
        if (scopeType.equals(RequestScoped.class)) {
            return this.getCurrentRequestContext();
        }
        if (scopeType.equals(SessionScoped.class)) {
            return this.getCurrentSessionContext();
        }
        if (scopeType.equals(ApplicationScoped.class)) {
            return this.applicationContext;
        }
        if (scopeType.equals(ConversationScoped.class) && this.supportsConversation) {
            return this.getCurrentConversationContext();
        }
        if (scopeType.equals(Dependent.class)) {
            return this.getCurrentDependentContext();
        }
        if (scopeType.equals(Singleton.class)) {
            return this.getCurrentSingletonContext();
        }
        return null;
    }

    @Override
    public void startContext(Class<? extends Annotation> scopeType, Object startParameter) throws ContextException {
        try {
            if (scopeType.equals(RequestScoped.class)) {
                this.startRequestContext();
            } else if (scopeType.equals(SessionScoped.class)) {
                this.startSessionContext();
            } else if (scopeType.equals(ApplicationScoped.class)) {
                this.startApplicationContext();
            } else if (scopeType.equals(ConversationScoped.class)) {
                this.startConversationContext();
            } else if (scopeType.equals(Singleton.class)) {
                this.startSingletonContext();
            }
        }
        catch (ContextException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ContextException((Throwable)e);
        }
    }

    @Override
    public void destroy(Object destroyObject) {
        ConversationContext conversationCtx;
        SessionContext sessionCtx;
        RequestContext requestCtx = requestContext.get();
        if (requestCtx != null) {
            requestCtx.destroy();
            RequestScopedBeanInterceptorHandler.removeThreadLocals();
            requestContext.set(null);
            requestContext.remove();
        }
        if ((sessionCtx = sessionContext.get()) != null) {
            sessionCtx.destroy();
            SessionScopedBeanInterceptorHandler.removeThreadLocals();
            sessionContext.set(null);
            sessionContext.remove();
        }
        if ((conversationCtx = conversationContext.get()) != null) {
            conversationCtx.destroy();
            conversationContext.set(null);
            conversationContext.remove();
        }
        dependentContext.set(null);
        dependentContext.remove();
        this.destroyGlobalContexts();
    }

    protected void destroyGlobalContexts() {
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
            this.applicationContext.destroySystemBeans();
        }
    }

    private Context getCurrentConversationContext() {
        ConversationContext conversationCtx = conversationContext.get();
        if (conversationCtx == null) {
            conversationCtx = this.webBeansContext.getConversationManager().getConversationContext(this.getCurrentSessionContext());
            conversationContext.set(conversationCtx);
            String conversationId = this.webBeansContext.getConversationService().getConversationId();
            if (conversationId != null && conversationCtx.getConversation().isTransient()) {
                throw new NonexistentConversationException("Propogated conversation with cid=" + conversationId + " cannot be restored. It creates a new transient conversation.");
            }
            if (conversationCtx.getConversation().iUseIt() > 1) {
                throw new BusyConversationException("Propogated conversation with cid=" + conversationId + " is used by other request. It creates a new transient conversation");
            }
        }
        return conversationCtx;
    }

    private Context getCurrentDependentContext() {
        if (dependentContext.get() == null) {
            dependentContext.set(new DependentContext());
        }
        return (Context)dependentContext.get();
    }

    private Context getCurrentRequestContext() {
        return (Context)requestContext.get();
    }

    private Context getCurrentSessionContext() {
        return (Context)sessionContext.get();
    }

    private void startApplicationContext() {
        if (this.applicationContext != null && !this.applicationContext.isDestroyed()) {
            return;
        }
        ApplicationContext ctx = new ApplicationContext();
        ctx.setActive(true);
        this.applicationContext = ctx;
        this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(new Object(), (Annotation)((Object)InitializedLiteral.INSTANCE_APPLICATION_SCOPED));
    }

    private void startConversationContext() {
        ConversationManager conversationManager = this.webBeansContext.getConversationManager();
        ConversationContext ctx = conversationManager.getConversationContext(this.getCurrentSessionContext());
        ctx.setActive(true);
        conversationContext.set(ctx);
        ConversationImpl conversation = ctx.getConversation();
        if (conversation.isTransient()) {
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(conversationManager.getLifecycleEventPayload(ctx), (Annotation)((Object)InitializedLiteral.INSTANCE_CONVERSATION_SCOPED));
        } else {
            conversation.updateLastAccessTime();
        }
    }

    private void startRequestContext() {
        RequestContext ctx = new RequestContext();
        ctx.setActive(true);
        requestContext.set(ctx);
        if (this.shouldFireRequestLifecycleEvents()) {
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(ctx, (Annotation)((Object)InitializedLiteral.INSTANCE_REQUEST_SCOPED));
        }
    }

    private void startSessionContext() {
        SessionContext ctx = new SessionContext();
        ctx.setActive(true);
        sessionContext.set(ctx);
        this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(new Object(), (Annotation)((Object)InitializedLiteral.INSTANCE_SESSION_SCOPED));
    }

    private void startSingletonContext() {
        this.createSingletonContext();
        this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(new Object(), (Annotation)((Object)InitializedLiteral.INSTANCE_SINGLETON_SCOPED));
    }

    private void stopApplicationContext() {
        if (this.applicationContext != null && !this.applicationContext.isDestroyed()) {
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(new Object(), (Annotation)((Object)BeforeDestroyedLiteral.INSTANCE_APPLICATION_SCOPED));
            this.applicationContext.destroy();
            WebBeansContext.currentInstance().getBeanManagerImpl().clearCacheProxies();
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(new Object(), (Annotation)((Object)DestroyedLiteral.INSTANCE_APPLICATION_SCOPED));
        }
    }

    private void stopConversationContext() {
        if (conversationContext.get() != null) {
            conversationContext.get().destroy();
        }
        conversationContext.set(null);
        conversationContext.remove();
    }

    private void stopRequestContext() {
        RequestContext ctx;
        if (this.supportsConversation) {
            this.destroyOutdatedConversations(conversationContext.get());
            conversationContext.set(null);
            conversationContext.remove();
        }
        if (this.shouldFireRequestLifecycleEvents()) {
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(new Object(), (Annotation)((Object)BeforeDestroyedLiteral.INSTANCE_REQUEST_SCOPED));
        }
        if ((ctx = requestContext.get()) != null) {
            ctx.destroy();
        }
        requestContext.set(null);
        requestContext.remove();
        RequestScopedBeanInterceptorHandler.removeThreadLocals();
        if (this.shouldFireRequestLifecycleEvents()) {
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(ctx, (Annotation)((Object)DestroyedLiteral.INSTANCE_REQUEST_SCOPED));
        }
    }

    private void stopSessionContext() {
        this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(new Object(), (Annotation)((Object)BeforeDestroyedLiteral.INSTANCE_SESSION_SCOPED));
        if (sessionContext.get() != null) {
            sessionContext.get().destroy();
        }
        sessionContext.set(null);
        sessionContext.remove();
        SessionScopedBeanInterceptorHandler.removeThreadLocals();
        this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(new Object(), (Annotation)((Object)DestroyedLiteral.INSTANCE_SESSION_SCOPED));
    }

    private void stopSingletonContext() {
        this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(new Object(), (Annotation)((Object)BeforeDestroyedLiteral.INSTANCE_SINGLETON_SCOPED));
        this.destroySingletonContext();
        this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(new Object(), (Annotation)((Object)DestroyedLiteral.INSTANCE_SINGLETON_SCOPED));
    }
}

