/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Inject;
import org.apache.webbeans.component.creation.BaseProducerFactory;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.ProducerFieldProducer;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

public class FieldProducerFactory<P>
extends BaseProducerFactory<P> {
    protected AnnotatedField<? super P> producerField;

    public FieldProducerFactory(AnnotatedField<? super P> producerField, Bean<P> parent, WebBeansContext webBeansContext) {
        super(parent, webBeansContext);
        Asserts.assertNotNull(producerField, "producer method");
        if (producerField.isAnnotationPresent(Inject.class)) {
            throw new IllegalArgumentException("producer field has @Inject annotation: " + producerField);
        }
        Type type = producerField.getJavaMember().getGenericType();
        if (ParameterizedType.class.isInstance(type)) {
            for (Type arg : ((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments()) {
                if (!ClassUtil.isWildCardType(arg)) continue;
                throw new IllegalArgumentException("Wildcard are forbidden: " + type);
            }
        }
        this.producerField = producerField;
        this.defineDisposalMethod();
    }

    public <T> Producer<T> createProducer(Bean<T> bean) {
        Set<InjectionPoint> disposalIPs = this.getInjectionPoints(bean);
        ProducerFieldProducer producer = new ProducerFieldProducer(this.parent, this.producerField, this.disposalMethod, disposalIPs, this.webBeansContext);
        return this.webBeansContext.getWebBeansUtil().fireProcessProducerEvent(producer, (AnnotatedMember<?>)this.producerField);
    }

    public Class<?> getReturnType() {
        return this.producerField.getJavaMember().getType();
    }

    @Override
    protected AnnotatedMember<? super P> producerType() {
        return this.producerField;
    }
}

