/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.webbeans.config.PropertyLoader;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;

public class OpenWebBeansConfiguration {
    public static final String CONVERSATION_TIMEOUT_INTERVAL = "org.apache.webbeans.conversation.Conversation.timeoutInterval";
    public static final String ALLOW_PROXYING_PARAM = "javax.enterprise.inject.allowProxying.classes";
    public static final String INTERCEPTOR_FORCE_NO_CHECKED_EXCEPTIONS = "org.apache.webbeans.forceNoCheckedExceptions";
    public static final String STRICT_DYNAMIC_VALIDATION = "org.apache.webbeans.strictDynamicValidation";
    public static final String FAST_MATCHING = "org.apache.webbeans.container.InjectionResolver.fastMatching";
    public static final String USE_EJB_DISCOVERY = "org.apache.webbeans.spi.deployer.useEjbMetaDataDiscoveryService";
    public static final String CONTAINER_LIFECYCLE = "org.apache.webbeans.spi.ContainerLifecycle";
    public static final String JNDI_SERVICE = "org.apache.webbeans.spi.JNDIService";
    public static final String SCANNER_SERVICE = "org.apache.webbeans.spi.ScannerService";
    public static final String CONTEXTS_SERVICE = "org.apache.webbeans.spi.ContextsService";
    public static final String CONVERSATION_SERVICE = "org.apache.webbeans.spi.ConversationService";
    public static final String RESOURCE_INJECTION_SERVICE = "org.apache.webbeans.spi.ResourceInjectionService";
    public static final String SECURITY_SERVICE = "org.apache.webbeans.spi.SecurityService";
    public static final String VALIDATOR_SERVICE = "org.apache.webbeans.spi.ValidatorService";
    public static final String TRANSACTION_SERVICE = "org.apache.webbeans.spi.TransactionService";
    public static final String APPLICATION_IS_JSP = "org.apache.webbeans.application.jsp";
    public static final String APPLICATION_SUPPORTS_CONVERSATION = "org.apache.webbeans.application.supportsConversation";
    public static final String PRODUCER_INTERCEPTION_SUPPORT = "org.apache.webbeans.application.supportsProducerInterception";
    public static final String EL_ADAPTOR_SERVICE = "org.apache.webbeans.spi.adaptor.ELAdaptor";
    public static final String PROXY_MAPPING_PREFIX = "org.apache.webbeans.proxy.mapping.";
    public static final String USE_BDA_BEANSXML_SCANNER = "org.apache.webbeans.useBDABeansXMLScanner";
    public static final String SCAN_EXCLUSION_PATHS = "org.apache.webbeans.scanExclusionPaths";
    public static final String SCAN_ONLY_BEANS_XML_JARS = "org.apache.webbeans.scanBeansXmlOnly";
    public static final String IGNORED_INTERFACES = "org.apache.webbeans.ignoredDecoratorInterfaces";
    public static final String IGNORED_EXTENSIONS = "org.apache.webbeans.ignoredExtensions";
    public static final String SCAN_EXTENSION_JARS = "org.apache.webbeans.scanExtensionJars";
    public static final String EAGER_SESSION_INITIALISATION = "org.apache.webbeans.web.eagerSessionInitialisation";
    public static final String GENERATOR_JAVA_VERSION = "org.apache.webbeans.generator.javaVersion";
    private static final String DEFAULT_CONFIG_PROPERTIES_NAME = "META-INF/openwebbeans/openwebbeans.properties";
    private static final String AUTO_CONFIG = "auto";
    private final Properties configProperties = new Properties();
    private Set<String> ignoredInterfaces;
    private Set<String> ignoredExtensions;
    private Boolean scanExtensionJars;
    private Map<String, Set<String>> configuredLists = new HashMap<String, Set<String>>();
    private volatile List<String> proxyReservedPackages;

    public OpenWebBeansConfiguration(Properties properties) {
        this();
        this.configProperties.putAll((Map<?, ?>)properties);
    }

    public OpenWebBeansConfiguration() {
        this.parseConfiguration();
    }

    public synchronized void parseConfiguration() throws WebBeansConfigurationException {
        Properties newConfigProperties = PropertyLoader.getProperties(DEFAULT_CONFIG_PROPERTIES_NAME);
        this.configProperties.clear();
        if (newConfigProperties != null) {
            this.overrideWithGlobalSettings(newConfigProperties);
            this.configProperties.putAll((Map<?, ?>)newConfigProperties);
        }
    }

    public List<String> splitValues(String commaSeparatedVals) {
        ArrayList<String> values = new ArrayList<String>();
        if (commaSeparatedVals != null) {
            for (String value : commaSeparatedVals.split(",")) {
                if ((value = value.trim()).isEmpty()) continue;
                values.add(value);
            }
        }
        return values;
    }

    private void overrideWithGlobalSettings(Properties configProperties) {
        Properties systemProperties = System.getSecurityManager() != null ? this.doPrivilegedGetSystemProperties() : System.getProperties();
        Map<String, String> systemEnvironment = System.getenv();
        for (Map.Entry<Object, Object> property : configProperties.entrySet()) {
            String key = (String)property.getKey();
            String value = (String)property.getValue();
            value = systemProperties.getProperty(key) != null ? systemProperties.getProperty(key) : value;
            String envKey = key.replace('.', '_');
            value = systemEnvironment.get(envKey) != null ? systemEnvironment.get(envKey) : value;
            if (value == null) continue;
            configProperties.put(key, value);
        }
    }

    private Properties doPrivilegedGetSystemProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
    }

    public String getProperty(String key) {
        return this.configProperties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.configProperties.getProperty(key, defaultValue);
    }

    public synchronized void setProperty(String key, Object value) {
        this.configProperties.put(key, value);
    }

    public boolean isJspApplication() {
        String value = this.getProperty(APPLICATION_IS_JSP);
        return Boolean.valueOf(value);
    }

    public boolean supportsConversation() {
        String value = this.getProperty(APPLICATION_SUPPORTS_CONVERSATION);
        return Boolean.valueOf(value);
    }

    public boolean scanOnlyBeansXmlJars() {
        String value = this.getProperty(SCAN_ONLY_BEANS_XML_JARS);
        return "true".equalsIgnoreCase(value);
    }

    public boolean strictDynamicValidation() {
        String value = this.getProperty(STRICT_DYNAMIC_VALIDATION);
        return "true".equalsIgnoreCase(value);
    }

    public synchronized Set<String> getIgnoredInterfaces() {
        if (this.ignoredInterfaces == null) {
            this.ignoredInterfaces = this.getPropertyList(IGNORED_INTERFACES);
        }
        return this.ignoredInterfaces;
    }

    public synchronized Set<String> getIgnoredExtensions() {
        if (this.ignoredExtensions == null) {
            this.ignoredExtensions = this.getPropertyList(IGNORED_EXTENSIONS);
        }
        return this.ignoredExtensions;
    }

    public synchronized boolean getScanExtensionJars() {
        if (this.scanExtensionJars == null) {
            String property = this.getProperty(SCAN_EXTENSION_JARS);
            this.scanExtensionJars = property == null || Boolean.parseBoolean(property.trim());
        }
        return this.scanExtensionJars;
    }

    private Set<String> getPropertyList(String configKey) {
        String configValue = this.getProperty(configKey);
        if (configValue != null) {
            return new HashSet<String>(Arrays.asList(configValue.split("[,\\p{javaWhitespace}]")));
        }
        return Collections.emptySet();
    }

    public synchronized Set<String> getConfigListValues(String keyName) {
        Set<String> allValues = this.configuredLists.get(keyName);
        if (allValues != null) {
            return allValues;
        }
        allValues = new HashSet<String>();
        try {
            List<Properties> properties = PropertyLoader.loadAllProperties(DEFAULT_CONFIG_PROPERTIES_NAME);
            if (properties != null) {
                for (Properties property : properties) {
                    String values = (String)property.get(keyName);
                    allValues.addAll(this.splitValues(values));
                }
            }
        }
        catch (IOException e) {
            WebBeansLoggerFacade.getLogger(OpenWebBeansConfiguration.class).log(Level.SEVERE, "Error while loading the propertyFile META-INF/openwebbeans/openwebbeans.properties", e);
            return Collections.EMPTY_SET;
        }
        String value = System.getProperty(keyName);
        allValues.addAll(this.splitValues(value));
        String envKeyName = keyName.toUpperCase().replace(".", "_");
        value = System.getenv(envKeyName);
        allValues.addAll(this.splitValues(value));
        this.configuredLists.put(keyName, allValues);
        return allValues;
    }

    public synchronized void addConfigListValue(String keyName, String value) {
        Set<String> configListValues = this.getConfigListValues(keyName);
        configListValues.add(value);
    }

    public boolean supportsInterceptionOnProducers() {
        return Boolean.parseBoolean(this.getProperty(PRODUCER_INTERCEPTION_SUPPORT, "true"));
    }

    public String getGeneratorJavaVersion() {
        String generatorJavaVersion = this.getProperty(GENERATOR_JAVA_VERSION);
        if (generatorJavaVersion == null || AUTO_CONFIG.equals(generatorJavaVersion)) {
            return System.getProperty("java.version");
        }
        return generatorJavaVersion;
    }

    public boolean isSkipNoClassDefFoundErrorTriggers() {
        return Boolean.parseBoolean(this.getProperty("org.apache.webbeans.spi.deployer.skipNoClassDefFoundTriggers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getProxyReservedPackages() {
        if (this.proxyReservedPackages == null) {
            OpenWebBeansConfiguration openWebBeansConfiguration = this;
            synchronized (openWebBeansConfiguration) {
                if (this.proxyReservedPackages == null) {
                    String conf = this.getProperty("org.apache.webbeans.generator.proxyReservedPackages");
                    this.proxyReservedPackages = conf == null ? Arrays.asList("java.", "javax.", "sun.misc.") : Stream.concat(Stream.of("java.", "javax.", "sun.misc."), Stream.of(conf.split(",")).map(String::trim).filter(it -> !it.isEmpty())).distinct().collect(Collectors.toList());
                }
            }
        }
        return this.proxyReservedPackages;
    }
}

