/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import org.apache.paimon.Changelog;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.operation.SnapshotDeletion;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireChangelogImpl
implements ExpireSnapshots {
    public static final Logger LOG = LoggerFactory.getLogger(ExpireChangelogImpl.class);
    private final SnapshotManager snapshotManager;
    private final ConsumerManager consumerManager;
    private final SnapshotDeletion snapshotDeletion;
    private final boolean cleanEmptyDirectories;
    private final TagManager tagManager;
    private long olderThanMills = 0L;
    public int retainMin = 1;
    private int retainMax = Integer.MAX_VALUE;
    private int maxDeletes = Integer.MAX_VALUE;

    public ExpireChangelogImpl(SnapshotManager snapshotManager, TagManager tagManager, SnapshotDeletion snapshotDeletion, boolean cleanEmptyDirectories) {
        this.snapshotManager = snapshotManager;
        this.tagManager = tagManager;
        this.consumerManager = new ConsumerManager(snapshotManager.fileIO(), snapshotManager.tablePath());
        this.snapshotDeletion = snapshotDeletion;
        this.cleanEmptyDirectories = cleanEmptyDirectories;
    }

    @Override
    public ExpireChangelogImpl retainMax(int retainMax) {
        this.retainMax = retainMax;
        return this;
    }

    @Override
    public ExpireChangelogImpl retainMin(int retainMin) {
        this.retainMin = retainMin;
        return this;
    }

    @Override
    public ExpireChangelogImpl olderThanMills(long olderThanMills) {
        this.olderThanMills = olderThanMills;
        return this;
    }

    @Override
    public ExpireChangelogImpl maxDeletes(int maxDeletes) {
        this.maxDeletes = maxDeletes;
        return this;
    }

    @Override
    public int expire() {
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        if (latestSnapshotId == null) {
            return 0;
        }
        Long earliestSnapshotId = this.snapshotManager.earliestSnapshotId();
        if (earliestSnapshotId == null) {
            return 0;
        }
        Long latestChangelogId = this.snapshotManager.latestLongLivedChangelogId();
        if (latestChangelogId == null) {
            return 0;
        }
        Long earliestChangelogId = this.snapshotManager.earliestLongLivedChangelogId();
        if (earliestChangelogId == null) {
            return 0;
        }
        Preconditions.checkArgument(this.retainMax >= this.retainMin, "retainMax must greater than retainMin.");
        long min = Math.max(latestSnapshotId - (long)this.retainMax + 1L, earliestChangelogId);
        long maxExclusive = latestSnapshotId - (long)this.retainMin + 1L;
        maxExclusive = Math.min(maxExclusive, this.consumerManager.minNextSnapshot().orElse(Long.MAX_VALUE));
        maxExclusive = Math.min(maxExclusive, earliestChangelogId + (long)this.maxDeletes);
        maxExclusive = Math.min(maxExclusive, latestChangelogId);
        for (long id = min; id <= maxExclusive; ++id) {
            if (!this.snapshotManager.longLivedChangelogExists(id) || this.olderThanMills > this.snapshotManager.longLivedChangelog(id).timeMillis()) continue;
            return this.expireUntil(earliestChangelogId, id);
        }
        return this.expireUntil(earliestChangelogId, maxExclusive);
    }

    public int expireUntil(long earliestId, long endExclusiveId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Changelog expire range is [" + earliestId + ", " + endExclusiveId + ")");
        }
        for (long id = earliestId; id < endExclusiveId; ++id) {
            Changelog changelog;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete changelog files from snapshot #" + id);
            }
            if ((changelog = this.snapshotManager.longLivedChangelog(id)).changelogManifestList() != null) {
                this.snapshotDeletion.deleteAddedDataFiles(changelog.changelogManifestList());
                this.snapshotDeletion.cleanUnusedManifestList(changelog.changelogManifestList(), new HashSet<String>());
            }
            this.snapshotManager.fileIO().deleteQuietly(this.snapshotManager.longLivedChangelogPath(id));
        }
        if (this.cleanEmptyDirectories) {
            this.snapshotDeletion.cleanDataDirectories();
        }
        this.writeEarliestHintFile(endExclusiveId);
        return (int)(endExclusiveId - earliestId);
    }

    private void writeEarliestHintFile(long earliest) {
        try {
            this.snapshotManager.commitLongLivedChangelogEarliestHint(earliest);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

