/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.io.Serializable;
import org.apache.paimon.catalog.Identifier;

public class TableNameConverter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean caseSensitive;
    private final boolean mergeShards;
    private final String prefix;
    private final String suffix;

    public TableNameConverter(boolean caseSensitive) {
        this(caseSensitive, true, "", "");
    }

    public TableNameConverter(boolean caseSensitive, boolean mergeShards, String prefix, String suffix) {
        this.caseSensitive = caseSensitive;
        this.mergeShards = mergeShards;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public String convert(String originName) {
        String tableName = this.caseSensitive ? originName : originName.toLowerCase();
        return this.prefix + tableName + this.suffix;
    }

    public String convert(Identifier originIdentifier) {
        String rawName = this.mergeShards ? originIdentifier.getObjectName() : originIdentifier.getDatabaseName() + "_" + originIdentifier.getObjectName();
        return this.convert(rawName);
    }
}

