/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.serialization;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.json.JsonConverter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.ConverterType;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.util.Collector;
import org.apache.paimon.flink.action.cdc.CdcSourceRecord;

public class CdcDebeziumDeserializationSchema
implements DebeziumDeserializationSchema<CdcSourceRecord> {
    private static final long serialVersionUID = 1L;
    private transient JsonConverter jsonConverter;
    private final Boolean includeSchema;
    private final Map<String, Object> customConverterConfigs;

    public CdcDebeziumDeserializationSchema() {
        this(false);
    }

    public CdcDebeziumDeserializationSchema(Boolean includeSchema) {
        this(includeSchema, null);
    }

    public CdcDebeziumDeserializationSchema(Boolean includeSchema, Map<String, Object> customConverterConfigs) {
        this.includeSchema = includeSchema;
        this.customConverterConfigs = customConverterConfigs;
    }

    public void deserialize(SourceRecord record, Collector<CdcSourceRecord> out) throws Exception {
        if (this.jsonConverter == null) {
            this.initializeJsonConverter();
        }
        byte[] bytes = this.jsonConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
        out.collect((Object)new CdcSourceRecord(record.topic(), null, new String(bytes)));
    }

    private void initializeJsonConverter() {
        this.jsonConverter = new JsonConverter();
        HashMap<String, Object> configs = new HashMap<String, Object>(2);
        configs.put("converter.type", ConverterType.VALUE.getName());
        configs.put("schemas.enable", this.includeSchema);
        if (this.customConverterConfigs != null) {
            configs.putAll(this.customConverterConfigs);
        }
        this.jsonConverter.configure(configs);
    }

    public TypeInformation<CdcSourceRecord> getProducedType() {
        return TypeExtractor.getForClass(CdcSourceRecord.class);
    }
}

