/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import org.apache.paimon.CoreOptions;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.KeyAndBucketExtractor;
import org.apache.paimon.utils.Preconditions;

public class FixedBucketFromPkExtractor
implements KeyAndBucketExtractor<InternalRow> {
    private transient InternalRow primaryKey;
    private final boolean sameBucketKeyAndTrimmedPrimaryKey;
    private final int numBuckets;
    private final Projection bucketKeyProjection;
    private final Projection trimmedPrimaryKeyProjection;
    private final Projection partitionProjection;
    private final Projection logPrimaryKeyProjection;

    public FixedBucketFromPkExtractor(TableSchema schema) {
        this.numBuckets = new CoreOptions(schema.options()).bucket();
        Preconditions.checkArgument(this.numBuckets > 0, "Num bucket is illegal: " + this.numBuckets);
        this.sameBucketKeyAndTrimmedPrimaryKey = schema.bucketKeys().equals(schema.trimmedPrimaryKeys());
        this.bucketKeyProjection = CodeGenUtils.newProjection(schema.logicalPrimaryKeysType(), schema.bucketKeys().stream().mapToInt(schema.primaryKeys()::indexOf).toArray());
        this.trimmedPrimaryKeyProjection = CodeGenUtils.newProjection(schema.logicalPrimaryKeysType(), schema.trimmedPrimaryKeys().stream().mapToInt(schema.primaryKeys()::indexOf).toArray());
        this.partitionProjection = CodeGenUtils.newProjection(schema.logicalPrimaryKeysType(), schema.partitionKeys().stream().mapToInt(schema.primaryKeys()::indexOf).toArray());
        this.logPrimaryKeyProjection = CodeGenUtils.newProjection(schema.logicalRowType(), schema.projection(schema.primaryKeys()));
    }

    @Override
    public void setRecord(InternalRow record) {
        this.primaryKey = record;
    }

    @Override
    public BinaryRow partition() {
        return this.partitionProjection.apply(this.primaryKey);
    }

    private BinaryRow bucketKey() {
        if (this.sameBucketKeyAndTrimmedPrimaryKey) {
            return this.trimmedPrimaryKey();
        }
        return this.bucketKeyProjection.apply(this.primaryKey);
    }

    @Override
    public int bucket() {
        BinaryRow bucketKey = this.bucketKey();
        return KeyAndBucketExtractor.bucket(KeyAndBucketExtractor.bucketKeyHashCode(bucketKey), this.numBuckets);
    }

    @Override
    public BinaryRow trimmedPrimaryKey() {
        return this.trimmedPrimaryKeyProjection.apply(this.primaryKey);
    }

    @Override
    public BinaryRow logPrimaryKey() {
        return this.logPrimaryKeyProjection.apply(this.primaryKey);
    }
}

