/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.utils.Preconditions;

public final class FileStoreSourceSplitState {
    private final FileStoreSourceSplit split;
    private long recordsToSkip;

    public FileStoreSourceSplitState(FileStoreSourceSplit split) {
        this.split = Preconditions.checkNotNull(split);
        this.recordsToSkip = split.recordsToSkip();
    }

    public void setPosition(RecordAndPosition<RowData> position) {
        Preconditions.checkArgument(position.getOffset() == -1L);
        this.recordsToSkip = position.getRecordSkipCount();
    }

    public long recordsToSkip() {
        return this.recordsToSkip;
    }

    public FileStoreSourceSplit toSourceSplit() {
        return this.split.updateWithRecordsToSkip(this.recordsToSkip);
    }
}

