/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.statistics.FullFieldStatsCollector;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;

public interface PartitionPredicate {
    public boolean test(BinaryRow var1);

    public boolean test(long var1, InternalRow var3, InternalRow var4, InternalArray var5);

    @Nullable
    public static PartitionPredicate fromPredicate(RowType partitionType, Predicate predicate) {
        if (partitionType.getFieldCount() == 0 || predicate == null) {
            return null;
        }
        return new DefaultPartitionPredicate(predicate);
    }

    @Nullable
    public static PartitionPredicate fromMultiple(RowType partitionType, List<BinaryRow> partitions) {
        if (partitionType.getFieldCount() == 0 || partitions.isEmpty()) {
            return null;
        }
        return new MultiplePartitionPredicate(new RowDataToObjectArrayConverter(partitionType), new HashSet<BinaryRow>(partitions));
    }

    public static class MultiplePartitionPredicate
    implements PartitionPredicate {
        private final Set<BinaryRow> partitions;
        private final int fieldNum;
        private final Predicate[] min;
        private final Predicate[] max;

        private MultiplePartitionPredicate(RowDataToObjectArrayConverter converter, Set<BinaryRow> partitions) {
            this.partitions = partitions;
            RowType partitionType = converter.rowType();
            this.fieldNum = partitionType.getFieldCount();
            Serializer[] serializers = new Serializer[this.fieldNum];
            FullFieldStatsCollector[] collectors = new FullFieldStatsCollector[this.fieldNum];
            this.min = new Predicate[this.fieldNum];
            this.max = new Predicate[this.fieldNum];
            for (int i = 0; i < this.fieldNum; ++i) {
                serializers[i] = InternalSerializers.create(partitionType.getTypeAt(i));
                collectors[i] = new FullFieldStatsCollector();
            }
            for (BinaryRow part : partitions) {
                Object[] fields = converter.convert(part);
                for (int i = 0; i < fields.length; ++i) {
                    collectors[i].collect(fields[i], serializers[i]);
                }
            }
            PredicateBuilder builder = new PredicateBuilder(partitionType);
            for (int i = 0; i < collectors.length; ++i) {
                FieldStats stats = collectors[i].result();
                this.min[i] = builder.greaterOrEqual(i, stats.minValue());
                this.max[i] = builder.lessOrEqual(i, stats.maxValue());
            }
        }

        @Override
        public boolean test(BinaryRow part) {
            return this.partitions.contains(part);
        }

        @Override
        public boolean test(long rowCount, InternalRow minValues, InternalRow maxValues, InternalArray nullCounts) {
            if (this.fieldNum == 0) {
                return true;
            }
            for (int i = 0; i < this.fieldNum; ++i) {
                if (this.min[i].test(rowCount, minValues, maxValues, nullCounts) && this.max[i].test(rowCount, minValues, maxValues, nullCounts)) continue;
                return false;
            }
            return true;
        }
    }

    public static class DefaultPartitionPredicate
    implements PartitionPredicate {
        private final Predicate predicate;

        private DefaultPartitionPredicate(Predicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(BinaryRow part) {
            return this.predicate.test(part);
        }

        @Override
        public boolean test(long rowCount, InternalRow minValues, InternalRow maxValues, InternalArray nullCounts) {
            return this.predicate.test(rowCount, minValues, maxValues, nullCounts);
        }
    }
}

