/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.net.openhft.hashing;

import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.paimon.shade.net.openhft.hashing.Access;
import org.apache.paimon.shade.net.openhft.hashing.LongHashFunction;
import org.apache.paimon.shade.net.openhft.hashing.LongTupleHashFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
abstract class DualHashFunction
extends LongTupleHashFunction {
    private static final long serialVersionUID = 0L;
    private final transient int resultLength = this.newResultArray().length;
    @NotNull
    private final transient LongHashFunction longHashFunction = new LongHashFunction(){

        @Override
        public long hashLong(long input) {
            return DualHashFunction.this.dualHashLong(input, null);
        }

        @Override
        public long hashInt(int input) {
            return DualHashFunction.this.dualHashInt(input, null);
        }

        @Override
        public long hashShort(short input) {
            return DualHashFunction.this.dualHashShort(input, null);
        }

        @Override
        public long hashChar(char input) {
            return DualHashFunction.this.dualHashChar(input, null);
        }

        @Override
        public long hashByte(byte input) {
            return DualHashFunction.this.dualHashByte(input, null);
        }

        @Override
        public long hashVoid() {
            return DualHashFunction.this.dualHashVoid(null);
        }

        @Override
        public <T> long hash(@Nullable T input, Access<T> access, long off, long len) {
            return DualHashFunction.this.dualHash(input, access, off, len, null);
        }
    };

    DualHashFunction() {
    }

    private void checkResult(long[] result) {
        if (null == result) {
            throw new NullPointerException();
        }
        if (result.length < this.resultLength) {
            throw new IllegalArgumentException("The input result array has not enough space!");
        }
    }

    protected abstract long dualHashLong(long var1, @Nullable long[] var3);

    @Override
    public void hashLong(long input, long[] result) {
        this.checkResult(result);
        this.dualHashLong(input, result);
    }

    protected abstract long dualHashInt(int var1, @Nullable long[] var2);

    @Override
    public void hashInt(int input, long[] result) {
        this.checkResult(result);
        this.dualHashInt(input, result);
    }

    protected abstract long dualHashShort(short var1, @Nullable long[] var2);

    @Override
    public void hashShort(short input, long[] result) {
        this.checkResult(result);
        this.dualHashShort(input, result);
    }

    protected abstract long dualHashChar(char var1, @Nullable long[] var2);

    @Override
    public void hashChar(char input, long[] result) {
        this.checkResult(result);
        this.dualHashChar(input, result);
    }

    protected abstract long dualHashByte(byte var1, @Nullable long[] var2);

    @Override
    public void hashByte(byte input, long[] result) {
        this.checkResult(result);
        this.dualHashByte(input, result);
    }

    protected abstract long dualHashVoid(@Nullable long[] var1);

    @Override
    public void hashVoid(long[] result) {
        this.checkResult(result);
        this.dualHashVoid(result);
    }

    protected abstract <T> long dualHash(@Nullable T var1, Access<T> var2, long var3, long var5, @Nullable long[] var7);

    @Override
    public <T> void hash(@Nullable T input, Access<T> access, long off, long len, long[] result) {
        this.checkResult(result);
        this.dualHash(input, access, off, len, result);
    }

    @Override
    public <T> long[] hash(@Nullable T input, Access<T> access, long off, long len) {
        long[] result = this.newResultArray();
        this.dualHash(input, access, off, len, result);
        return result;
    }

    @NotNull
    protected LongHashFunction asLongHashFunction() {
        return this.longHashFunction;
    }
}

