/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.execution.JobClient;
import org.apache.paimon.catalog.FileSystemCatalogOptions;
import org.apache.paimon.flink.action.ActionBase;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBActionITCaseBase;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBSyncTableAction;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MongoDBSyncTableActionITCase
extends MongoDBActionITCaseBase {
    @Test
    @Timeout(value=60L)
    public void testSchemaEvolution() throws Exception {
        this.runSingleTableSchemaEvolution("inventory-1");
    }

    private void runSingleTableSchemaEvolution(String sourceDir) throws Exception {
        String inventory = this.createRecordsToMongoDB(sourceDir, "table");
        Map<String, String> mongodbConfig = this.getBasicMongoDBConfig();
        mongodbConfig.put("database", inventory);
        mongodbConfig.put("collection", "products");
        MongoDBSyncTableAction action = (MongoDBSyncTableAction)this.syncTableActionBuilder(mongodbConfig).withTableConfig(this.getBasicTableConfig()).build();
        this.runActionWithDefaultEnv((ActionBase)action);
        this.testSchemaEvolutionImpl(inventory);
    }

    private void testSchemaEvolutionImpl(String dbName) throws Exception {
        FileStoreTable table = this.getFileStoreTable(this.tableName);
        List<String> primaryKeys = Collections.singletonList("_id");
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"_id", "name", "description", "weight"});
        List<String> expected = Arrays.asList("+I[100000000000000000000101, scooter, Small 2-wheel scooter, 3.14]", "+I[100000000000000000000102, car battery, 12V car battery, 8.1]", "+I[100000000000000000000103, 12-pack drill bits, 12-pack of drill bits with sizes ranging from #40 to #3, 0.8]");
        this.waitForResult(expected, table, rowType, primaryKeys);
        MongoDBSyncTableActionITCase.writeRecordsToMongoDB("inventory-2", dbName, "table");
        rowType = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"_id", "name", "description", "weight"});
        expected = Arrays.asList("+I[100000000000000000000101, scooter, Small 2-wheel scooter, 350]", "+I[100000000000000000000102, car battery, High-performance car battery, 8.1]", "+I[100000000000000000000103, 12-pack drill bits, Set of 12 professional-grade drill bits, 0.8]");
        this.waitForResult(expected, table, rowType, primaryKeys);
        MongoDBSyncTableActionITCase.writeRecordsToMongoDB("inventory-3", dbName, "table");
        rowType = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"_id", "name", "description", "weight", "hobby", "age", "address"});
        expected = Arrays.asList("+I[100000000000000000000102, car battery, High-performance car battery, 8.1, NULL, 18, NULL]", "+I[100000000000000000000103, 12-pack drill bits, Set of 12 professional-grade drill bits, 0.8, NULL, NULL, I live in Sanlitun]", "+I[100000000000000000000101, scooter, Small 2-wheel scooter, 350, playing computer games, NULL, NULL]");
        this.waitForResult(expected, table, rowType, primaryKeys);
    }

    @Test
    @Timeout(value=60L)
    public void testSpecifiedMode() throws Exception {
        String inventory = this.createRecordsToMongoDB("inventory-1", "table");
        Map<String, String> mongodbConfig = this.getBasicMongoDBConfig();
        mongodbConfig.put("database", inventory);
        mongodbConfig.put("collection", "products");
        mongodbConfig.put("field.name", "_id,name,description");
        mongodbConfig.put("parser.path", "$._id,$.name,$.description");
        mongodbConfig.put("schema.start.mode", "specified");
        MongoDBSyncTableAction action = (MongoDBSyncTableAction)this.syncTableActionBuilder(mongodbConfig).withTableConfig(this.getBasicTableConfig()).build();
        this.runActionWithDefaultEnv((ActionBase)action);
        FileStoreTable table = this.getFileStoreTable(this.tableName);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"_id", "name", "description"});
        List<String> primaryKeys = Collections.singletonList("_id");
        List<String> expected = Arrays.asList("+I[100000000000000000000101, scooter, Small 2-wheel scooter]", "+I[100000000000000000000102, car battery, 12V car battery]", "+I[100000000000000000000103, 12-pack drill bits, 12-pack of drill bits with sizes ranging from #40 to #3]");
        this.waitForResult(expected, table, rowType, primaryKeys);
    }

    @Test
    public void testCatalogAndTableConfig() {
        MongoDBSyncTableAction action = (MongoDBSyncTableAction)this.syncTableActionBuilder(this.getBasicMongoDBConfig()).withCatalogConfig(Collections.singletonMap("catalog-key", "catalog-value")).withTableConfig(Collections.singletonMap("table-key", "table-value")).build();
        Assertions.assertThat((Map)action.catalogConfig()).containsEntry((Object)"catalog-key", (Object)"catalog-value");
        Assertions.assertThat((Map)action.tableConfig()).containsExactlyEntriesOf(Collections.singletonMap("table-key", "table-value"));
    }

    @Test
    @Timeout(value=60L)
    public void testOptionsChange() throws Exception {
        HashMap<String, String> tableConfig = new HashMap<String, String>();
        tableConfig.put("bucket", "1");
        tableConfig.put("sink.parallelism", "1");
        String inventory = this.createRecordsToMongoDB("inventory-1", "table");
        Map<String, String> mongodbConfig = this.getBasicMongoDBConfig();
        mongodbConfig.put("database", inventory);
        mongodbConfig.put("collection", "products");
        mongodbConfig.put("field.name", "_id,name,description");
        mongodbConfig.put("parser.path", "$._id,$.name,$.description");
        mongodbConfig.put("schema.start.mode", "specified");
        MongoDBSyncTableAction action1 = (MongoDBSyncTableAction)this.syncTableActionBuilder(mongodbConfig).withTableConfig(tableConfig).build();
        JobClient jobClient = this.runActionWithDefaultEnv((ActionBase)action1);
        this.waitingTables(this.tableName);
        jobClient.cancel();
        tableConfig.put("sink.savepoint.auto-tag", "true");
        tableConfig.put("tag.num-retained-max", "5");
        tableConfig.put("tag.automatic-creation", "process-time");
        tableConfig.put("tag.creation-period", "hourly");
        tableConfig.put("tag.creation-delay", "600000");
        tableConfig.put("snapshot.time-retained", "1h");
        tableConfig.put("snapshot.num-retained.min", "5");
        tableConfig.put("snapshot.num-retained.max", "10");
        tableConfig.put("changelog-producer", "input");
        MongoDBSyncTableAction action2 = (MongoDBSyncTableAction)this.syncTableActionBuilder(mongodbConfig).withTableConfig(tableConfig).build();
        this.runActionWithDefaultEnv((ActionBase)action2);
        FileStoreTable table = this.getFileStoreTable(this.tableName);
        Assertions.assertThat((Map)table.options()).containsAllEntriesOf(tableConfig);
    }

    @Test
    @Timeout(value=60L)
    public void testComputedColumn() throws Exception {
        MongoDBSyncTableActionITCase.writeRecordsToMongoDB("test-table-1", this.database, "table/computedcolumn");
        Map<String, String> mongodbConfig = this.getBasicMongoDBConfig();
        mongodbConfig.put("database", this.database);
        mongodbConfig.put("collection", "test_computed_column");
        MongoDBSyncTableAction action = (MongoDBSyncTableAction)this.syncTableActionBuilder(mongodbConfig).withTableConfig(this.getBasicTableConfig()).withComputedColumnArgs("_year=year(_date)").build();
        this.runActionWithDefaultEnv((ActionBase)action);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.INT()}, (String[])new String[]{"_id", "_date", "_year"});
        this.waitForResult(Collections.singletonList("+I[100000000000000000000101, 2023-03-23, 2023]"), this.getFileStoreTable(this.tableName), rowType, Collections.singletonList("_id"));
    }

    @Test
    @Timeout(value=60L)
    public void testMongoDBCDCOperations() throws Exception {
        MongoDBSyncTableActionITCase.writeRecordsToMongoDB("event-insert", this.database, "table/event");
        Map<String, String> mongodbConfig = this.getBasicMongoDBConfig();
        mongodbConfig.put("database", this.database);
        mongodbConfig.put("collection", "event");
        MongoDBSyncTableAction action = (MongoDBSyncTableAction)this.syncTableActionBuilder(mongodbConfig).withTableConfig(this.getBasicTableConfig()).build();
        this.runActionWithDefaultEnv((ActionBase)action);
        FileStoreTable table = this.getFileStoreTable(this.tableName);
        List<String> primaryKeys = Collections.singletonList("_id");
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"_id", "name", "description", "weight"});
        List<String> expectedInsert = Arrays.asList("+I[100000000000000000000101, scooter, Small 2-wheel scooter, 3.14]", "+I[100000000000000000000102, car battery, 12V car battery, 8.1]", "+I[100000000000000000000103, 12-pack drill bits, 12-pack of drill bits with sizes ranging from #40 to #3, 0.8]");
        this.waitForResult(expectedInsert, table, rowType, primaryKeys);
        MongoDBSyncTableActionITCase.writeRecordsToMongoDB("event-update", this.database, "table/event");
        List<String> expectedUpdate = Arrays.asList("+I[100000000000000000000101, scooter, Updated scooter description, 4]", "+I[100000000000000000000102, car battery, 12V car battery, 8.1]", "+I[100000000000000000000103, 12-pack drill bits, 12-pack of drill bits with sizes ranging from #40 to #3, 0.8]");
        this.waitForResult(expectedUpdate, table, rowType, primaryKeys);
        MongoDBSyncTableActionITCase.writeRecordsToMongoDB("event-replace", this.database, "table/event");
        List<String> expectedReplace = Arrays.asList("+I[100000000000000000000101, scooter, Updated scooter description, 4]", "+I[100000000000000000000102, new car battery, New 12V car battery, 9]", "+I[100000000000000000000103, 12-pack drill bits, 12-pack of drill bits with sizes ranging from #40 to #3, 0.8]");
        this.waitForResult(expectedReplace, table, rowType, primaryKeys);
        MongoDBSyncTableActionITCase.writeRecordsToMongoDB("event-delete", this.database, "table/event");
        List<String> expectedDelete = Arrays.asList("+I[100000000000000000000101, scooter, Updated scooter description, 4]", "+I[100000000000000000000102, new car battery, New 12V car battery, 9]");
        this.waitForResult(expectedDelete, table, rowType, primaryKeys);
    }

    @Test
    @Timeout(value=60L)
    public void testDefaultId() throws Exception {
        MongoDBSyncTableActionITCase.writeRecordsToMongoDB("defaultId-1", this.database, "table/defaultid");
        Map<String, String> mongodbConfig = this.getBasicMongoDBConfig();
        mongodbConfig.put("database", this.database);
        mongodbConfig.put("collection", "defaultId1");
        mongodbConfig.put("default.id.generation", "false");
        MongoDBSyncTableAction action = (MongoDBSyncTableAction)this.syncTableActionBuilder(mongodbConfig).withTableConfig(this.getBasicTableConfig()).build();
        this.runActionWithDefaultEnv((ActionBase)action);
        FileStoreTable table = this.getFileStoreTable(this.tableName);
        List<String> primaryKeys = Collections.singletonList("_id");
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"_id", "name", "description", "weight"});
        List<String> expectedInsert = Arrays.asList("+I[{\"$oid\":\"100000000000000000000101\"}, scooter, Small 2-wheel scooter, 3.14]", "+I[{\"$oid\":\"100000000000000000000102\"}, car battery, 12V car battery, 8.1]", "+I[{\"$oid\":\"100000000000000000000103\"}, 12-pack drill bits, 12-pack of drill bits with sizes ranging from #40 to #3, 0.8]");
        this.waitForResult(expectedInsert, table, rowType, primaryKeys);
    }

    @Test
    @Timeout(value=60L)
    public void testPrimaryKeyNotObjectIdType() throws Exception {
        MongoDBSyncTableActionITCase.writeRecordsToMongoDB("defaultId-2", this.database, "table/defaultid");
        Map<String, String> mongodbConfig = this.getBasicMongoDBConfig();
        mongodbConfig.put("database", this.database);
        mongodbConfig.put("collection", "defaultId2");
        MongoDBSyncTableAction action = (MongoDBSyncTableAction)this.syncTableActionBuilder(mongodbConfig).withTableConfig(this.getBasicTableConfig()).build();
        this.runActionWithDefaultEnv((ActionBase)action);
        FileStoreTable table = this.getFileStoreTable(this.tableName);
        List<String> primaryKeys = Collections.singletonList("_id");
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"_id", "name", "description", "weight"});
        List<String> expectedInsert = Arrays.asList("+I[100000000000000000000101, scooter, Small 2-wheel scooter, 3.14]", "+I[100000000000000000000102, car battery, 12V car battery, 8.1]", "+I[100000000000000000000103, 12-pack drill bits, 12-pack of drill bits with sizes ranging from #40 to #3, 0.8]");
        this.waitForResult(expectedInsert, table, rowType, primaryKeys);
    }

    @Test
    @Timeout(value=60L)
    public void testComputedColumnWithCaseInsensitive() throws Exception {
        MongoDBSyncTableActionITCase.writeRecordsToMongoDB("test-table-2", this.database, "table/computedcolumn");
        Map<String, String> mongodbConfig = this.getBasicMongoDBConfig();
        mongodbConfig.put("database", this.database);
        mongodbConfig.put("collection", "computed_column_with_case_insensitive");
        MongoDBSyncTableAction action = (MongoDBSyncTableAction)this.syncTableActionBuilder(mongodbConfig).withTableConfig(this.getBasicTableConfig()).withCatalogConfig(Collections.singletonMap(FileSystemCatalogOptions.CASE_SENSITIVE.key(), "false")).withComputedColumnArgs("_YEAR=year(_DATE)").build();
        this.runActionWithDefaultEnv((ActionBase)action);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.STRING().notNull(), DataTypes.STRING(), DataTypes.INT()}, (String[])new String[]{"_id", "_date", "_year"});
        this.waitForResult(Arrays.asList("+I[100000000000000000000101, 2023-12-11, 2023]", "+I[100000000000000000000102, NULL, NULL]"), this.getFileStoreTable(this.tableName), rowType, Collections.singletonList("_id"));
    }
}

