/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.format.debezium;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.action.cdc.mysql.MySqlTypeUtils;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.StringUtils;

public class DebeziumSchemaUtils {
    public static String transformRawValue(@Nullable String rawValue, String debeziumType, @Nullable String className, TypeMapping typeMapping, JsonNode origin, ZoneId serverTimeZone) {
        if (rawValue == null) {
            return null;
        }
        String transformed = rawValue;
        if ("io.debezium.data.Bits".equals(className)) {
            byte[] littleEndian = Base64.getDecoder().decode(rawValue);
            byte[] bigEndian = new byte[littleEndian.length];
            for (int i = 0; i < littleEndian.length; ++i) {
                bigEndian[i] = littleEndian[littleEndian.length - 1 - i];
            }
            transformed = typeMapping.containsMode(TypeMapping.TypeMappingMode.TO_STRING) ? StringUtils.bytesToBinaryString((byte[])bigEndian) : Base64.getEncoder().encodeToString(bigEndian);
        } else if ("bytes".equals(debeziumType) && className == null) {
            transformed = new String(Base64.getDecoder().decode(rawValue));
        } else {
            if ("bytes".equals(debeziumType) && DebeziumSchemaUtils.decimalLogicalName().equals(className)) {
                try {
                    new BigDecimal(rawValue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid big decimal value " + rawValue + ". Make sure that in the `customConverterConfigs` of the JsonDebeziumDeserializationSchema you created, set '" + "decimal.format" + "' to 'numeric'", e);
                }
            }
            if ("io.debezium.time.Date".equals(className)) {
                transformed = DateTimeUtils.toLocalDate((int)Integer.parseInt(rawValue)).toString();
            } else if ("io.debezium.time.Timestamp".equals(className)) {
                LocalDateTime localDateTime = DateTimeUtils.toLocalDateTime((long)Long.parseLong(rawValue), (ZoneId)ZoneOffset.UTC);
                transformed = DateTimeUtils.formatLocalDateTime((LocalDateTime)localDateTime, (int)3);
            } else if ("io.debezium.time.MicroTimestamp".equals(className)) {
                long microseconds = Long.parseLong(rawValue);
                long microsecondsPerSecond = 1000000L;
                long nanosecondsPerMicros = 1000L;
                long seconds = microseconds / microsecondsPerSecond;
                long nanoAdjustment = microseconds % microsecondsPerSecond * nanosecondsPerMicros;
                LocalDateTime localDateTime = Instant.ofEpochSecond(seconds, nanoAdjustment).atZone(ZoneOffset.UTC).toLocalDateTime();
                transformed = DateTimeUtils.formatLocalDateTime((LocalDateTime)localDateTime, (int)6);
            } else if ("io.debezium.time.ZonedTimestamp".equals(className)) {
                LocalDateTime localDateTime = Instant.parse(rawValue).atZone(serverTimeZone).toLocalDateTime();
                transformed = DateTimeUtils.formatLocalDateTime((LocalDateTime)localDateTime, (int)6);
            } else if ("io.debezium.time.MicroTime".equals(className)) {
                long microseconds = Long.parseLong(rawValue);
                long microsecondsPerSecond = 1000000L;
                long nanosecondsPerMicros = 1000L;
                long seconds = microseconds / microsecondsPerSecond;
                long nanoAdjustment = microseconds % microsecondsPerSecond * nanosecondsPerMicros;
                transformed = Instant.ofEpochSecond(seconds, nanoAdjustment).atZone(ZoneOffset.UTC).toLocalTime().toString();
            } else if ("io.debezium.data.geometry.Point".equals(className) || "io.debezium.data.geometry.Geometry".equals(className)) {
                try {
                    byte[] wkb = origin.get("wkb").binaryValue();
                    transformed = MySqlTypeUtils.convertWkbArray(wkb);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Failed to convert %s to geometry JSON.", rawValue), e);
                }
            }
        }
        return transformed;
    }

    public static DataType toDataType(String debeziumType, @Nullable String className, Map<String, String> parameters) {
        if (className == null) {
            return DebeziumSchemaUtils.fromDebeziumType(debeziumType);
        }
        if ("io.debezium.data.Bits".equals(className)) {
            int length = Integer.parseInt(parameters.get("length"));
            return DataTypes.BINARY((int)((length + 7) / 8));
        }
        if (DebeziumSchemaUtils.decimalLogicalName().equals(className)) {
            String precision = parameters.get("connect.decimal.precision");
            if (precision == null) {
                return DataTypes.DECIMAL((int)20, (int)0);
            }
            int p = Integer.parseInt(precision);
            if (p > 38) {
                return DataTypes.STRING();
            }
            int scale = Integer.parseInt(parameters.get("scale"));
            return DataTypes.DECIMAL((int)p, (int)scale);
        }
        if ("io.debezium.time.Date".equals(className)) {
            return DataTypes.DATE();
        }
        if ("io.debezium.time.Timestamp".equals(className)) {
            return DataTypes.TIMESTAMP((int)3);
        }
        if ("io.debezium.time.MicroTimestamp".equals(className) || "io.debezium.time.ZonedTimestamp".equals(className)) {
            return DataTypes.TIMESTAMP((int)6);
        }
        if ("io.debezium.time.MicroTime".equals(className)) {
            return DataTypes.TIME();
        }
        return DebeziumSchemaUtils.fromDebeziumType(debeziumType);
    }

    private static DataType fromDebeziumType(String dbzType) {
        switch (dbzType) {
            case "int8": {
                return DataTypes.TINYINT();
            }
            case "int16": {
                return DataTypes.SMALLINT();
            }
            case "int32": {
                return DataTypes.INT();
            }
            case "int64": {
                return DataTypes.BIGINT();
            }
            case "float32": 
            case "float64": {
                return DataTypes.FLOAT();
            }
            case "double": {
                return DataTypes.DOUBLE();
            }
            case "boolean": {
                return DataTypes.BOOLEAN();
            }
            case "bytes": {
                return DataTypes.BYTES();
            }
        }
        return DataTypes.STRING();
    }

    public static String decimalLogicalName() {
        return "org.apache.#.connect.data.Decimal".replace("#", "kafka");
    }
}

