/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.format.maxwell;

import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.flink.action.cdc.ComputedColumn;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.action.cdc.format.RecordParser;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.types.RowKind;

public class MaxwellRecordParser
extends RecordParser {
    private static final String FIELD_OLD = "old";
    private static final String FIELD_TYPE = "type";
    private static final String OP_INSERT = "insert";
    private static final String OP_UPDATE = "update";
    private static final String OP_DELETE = "delete";

    public MaxwellRecordParser(boolean caseSensitive, TypeMapping typeMapping, List<ComputedColumn> computedColumns) {
        super(caseSensitive, typeMapping, computedColumns);
    }

    @Override
    public List<RichCdcMultiplexRecord> extractRecords() {
        String operation = this.getAndCheck(FIELD_TYPE).asText();
        JsonNode data = this.getAndCheck(this.dataField());
        ArrayList<RichCdcMultiplexRecord> records = new ArrayList<RichCdcMultiplexRecord>();
        switch (operation) {
            case "insert": {
                this.processRecord(data, RowKind.INSERT, records);
                break;
            }
            case "update": {
                JsonNode old = this.getAndCheck(FIELD_OLD, FIELD_TYPE, operation);
                this.processRecord(this.mergeOldRecord(data, old), RowKind.DELETE, records);
                this.processRecord(data, RowKind.INSERT, records);
                break;
            }
            case "delete": {
                this.processRecord(data, RowKind.DELETE, records);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown record operation: " + operation);
            }
        }
        return records;
    }

    @Override
    protected String primaryField() {
        return "primary_key_columns";
    }

    @Override
    protected String dataField() {
        return "data";
    }

    @Override
    protected String format() {
        return "maxwell-json";
    }
}

