/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.format.ogg;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.cdc.ComputedColumn;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.action.cdc.format.RecordParser;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.JsonSerdeUtil;

public class OggRecordParser
extends RecordParser {
    private static final String FIELD_BEFORE = "before";
    private static final String FIELD_TYPE = "op_type";
    private static final String OP_UPDATE = "U";
    private static final String OP_INSERT = "I";
    private static final String OP_DELETE = "D";

    public OggRecordParser(boolean caseSensitive, TypeMapping typeMapping, List<ComputedColumn> computedColumns) {
        super(caseSensitive, typeMapping, computedColumns);
    }

    @Override
    public List<RichCdcMultiplexRecord> extractRecords() {
        String operation;
        ArrayList<RichCdcMultiplexRecord> records = new ArrayList<RichCdcMultiplexRecord>();
        switch (operation = this.getAndCheck(FIELD_TYPE).asText()) {
            case "U": {
                this.processRecord(this.getBefore(operation), RowKind.DELETE, records);
                this.processRecord(this.getData(), RowKind.INSERT, records);
                break;
            }
            case "I": {
                this.processRecord(this.getData(), RowKind.INSERT, records);
                break;
            }
            case "D": {
                this.processRecord(this.getBefore(operation), RowKind.DELETE, records);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown record operation: " + operation);
            }
        }
        return records;
    }

    private JsonNode getData() {
        return this.getAndCheck(this.dataField());
    }

    private JsonNode getBefore(String op) {
        return this.getAndCheck(FIELD_BEFORE, FIELD_TYPE, op);
    }

    @Override
    protected String primaryField() {
        return "primary_keys";
    }

    @Override
    protected String dataField() {
        return "after";
    }

    @Override
    @Nullable
    protected String getTableName() {
        Identifier id = this.getTableId();
        return id == null ? null : id.getObjectName();
    }

    @Override
    @Nullable
    protected String getDatabaseName() {
        Identifier id = this.getTableId();
        return id == null ? null : id.getDatabaseName();
    }

    @Nullable
    private Identifier getTableId() {
        JsonNode node = this.root.get("table");
        if (JsonSerdeUtil.isNull((JsonNode)node)) {
            return null;
        }
        return Identifier.fromString((String)node.asText());
    }

    @Override
    protected String format() {
        return "ogg-json";
    }
}

