/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql;

import com.ververica.cdc.connectors.mysql.source.MySqlSource;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.cdc.CdcSourceRecord;
import org.apache.paimon.flink.action.cdc.SyncJobHandler;
import org.apache.paimon.flink.action.cdc.SyncTableActionBase;
import org.apache.paimon.flink.action.cdc.mysql.MySqlActionUtils;
import org.apache.paimon.flink.action.cdc.schema.JdbcSchemasInfo;
import org.apache.paimon.flink.action.cdc.schema.JdbcTableInfo;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.utils.Preconditions;

public class MySqlSyncTableAction
extends SyncTableActionBase {
    private JdbcSchemasInfo mySqlSchemasInfo;

    public MySqlSyncTableAction(String warehouse, String database, String table, Map<String, String> catalogConfig, Map<String, String> mySqlConfig) {
        super(warehouse, database, table, catalogConfig, mySqlConfig, SyncJobHandler.SourceType.MYSQL);
    }

    @Override
    protected Schema retrieveSchema() throws Exception {
        this.mySqlSchemasInfo = MySqlActionUtils.getMySqlTableInfos(this.cdcSourceConfig, this.monitorTablePredication(), new ArrayList<Identifier>(), this.typeMapping);
        this.validateMySqlTableInfos(this.mySqlSchemasInfo);
        JdbcTableInfo tableInfo = this.mySqlSchemasInfo.mergeAll();
        return tableInfo.schema();
    }

    protected MySqlSource<CdcSourceRecord> buildSource() {
        String tableList = String.format("(%s)\\.(%s)", this.cdcSourceConfig.get(MySqlSourceOptions.DATABASE_NAME), this.cdcSourceConfig.get(MySqlSourceOptions.TABLE_NAME));
        return MySqlActionUtils.buildMySqlSource(this.cdcSourceConfig, tableList, this.typeMapping);
    }

    private void validateMySqlTableInfos(JdbcSchemasInfo mySqlSchemasInfo) {
        List<Identifier> nonPkTables = mySqlSchemasInfo.nonPkTables();
        Preconditions.checkArgument((boolean)nonPkTables.isEmpty(), (String)"Source tables of MySQL table synchronization job cannot contain table which doesn't have primary keys.\nThey are: %s", (Object[])new Object[]{nonPkTables.stream().map(Identifier::getFullName).collect(Collectors.joining(","))});
        Preconditions.checkArgument((!mySqlSchemasInfo.pkTables().isEmpty() ? 1 : 0) != 0, (Object)"No table satisfies the given database name and table name.");
    }

    private Predicate<String> monitorTablePredication() {
        return tableName -> {
            Pattern tableNamePattern = Pattern.compile((String)this.cdcSourceConfig.get(MySqlSourceOptions.TABLE_NAME));
            return tableNamePattern.matcher((CharSequence)tableName).matches();
        };
    }
}

