/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.kafka;

import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaProducer;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.flink.kafka.KafkaLogSerializationSchema;
import org.apache.paimon.flink.kafka.KafkaSinkFunction;
import org.apache.paimon.flink.log.LogSinkProvider;
import org.apache.paimon.flink.sink.LogSinkFunction;

public class KafkaLogSinkProvider
implements LogSinkProvider {
    private static final long serialVersionUID = 1L;
    private final String topic;
    private final Properties properties;
    @Nullable
    private final SerializationSchema<RowData> primaryKeySerializer;
    private final SerializationSchema<RowData> valueSerializer;
    private final CoreOptions.LogConsistency consistency;
    private final CoreOptions.LogChangelogMode changelogMode;

    public KafkaLogSinkProvider(String topic, Properties properties, @Nullable SerializationSchema<RowData> primaryKeySerializer, SerializationSchema<RowData> valueSerializer, CoreOptions.LogConsistency consistency, CoreOptions.LogChangelogMode changelogMode) {
        this.topic = topic;
        this.properties = properties;
        this.primaryKeySerializer = primaryKeySerializer;
        this.valueSerializer = valueSerializer;
        this.consistency = consistency;
        this.changelogMode = changelogMode;
    }

    public LogSinkFunction createSink() {
        FlinkKafkaProducer.Semantic semantic;
        switch (this.consistency) {
            case TRANSACTIONAL: {
                semantic = FlinkKafkaProducer.Semantic.EXACTLY_ONCE;
                break;
            }
            case EVENTUAL: {
                semantic = FlinkKafkaProducer.Semantic.AT_LEAST_ONCE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported: " + this.consistency);
            }
        }
        return new KafkaSinkFunction(this.topic, this.createSerializationSchema(), this.properties, semantic);
    }

    @VisibleForTesting
    KafkaLogSerializationSchema createSerializationSchema() {
        return new KafkaLogSerializationSchema(this.topic, this.primaryKeySerializer, this.valueSerializer, this.changelogMode);
    }
}

