/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.cdc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.utils.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdcRecordUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CdcRecordUtils.class);

    public static GenericRow projectAsInsert(CdcRecord record, List<DataField> dataFields) {
        GenericRow genericRow = new GenericRow(dataFields.size());
        for (int i = 0; i < dataFields.size(); ++i) {
            DataField dataField = dataFields.get(i);
            String fieldValue = record.fields().get(dataField.name());
            if (StringUtils.isEmpty((CharSequence)fieldValue)) continue;
            genericRow.setField(i, TypeUtils.castFromCdcValueString((String)fieldValue, (DataType)dataField.type()));
        }
        return genericRow;
    }

    public static Optional<GenericRow> toGenericRow(CdcRecord record, List<DataField> dataFields) {
        GenericRow genericRow = new GenericRow(record.kind(), dataFields.size());
        List fieldNames = dataFields.stream().map(DataField::name).collect(Collectors.toList());
        for (Map.Entry<String, String> field : record.fields().entrySet()) {
            String key = field.getKey();
            String value = field.getValue();
            int idx = fieldNames.indexOf(key);
            if (idx < 0) {
                LOG.info("Field " + key + " not found. Waiting for schema update.");
                return Optional.empty();
            }
            if (value == null) continue;
            DataType type = dataFields.get(idx).type();
            try {
                genericRow.setField(idx, TypeUtils.castFromCdcValueString((String)value, (DataType)type));
            }
            catch (Exception e) {
                LOG.info("Failed to convert value " + value + " to type " + type + ". Waiting for schema update.", (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.of(genericRow);
    }

    public static CdcRecord fromGenericRow(GenericRow row, List<String> fieldNames) {
        HashMap<String, String> fields = new HashMap<String, String>();
        for (int i = 0; i < row.getFieldCount(); ++i) {
            Object field = row.getField(i);
            if (field == null) continue;
            fields.put(fieldNames.get(i), field.toString());
        }
        return new CdcRecord(row.getRowKind(), fields);
    }
}

