/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.paimon.flink.FlinkTestBase;
import org.apache.paimon.flink.ShowCreateUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.provider.Arguments;

public class CreateTableITCase
extends FlinkTestBase {
    @Override
    public void prepareEnv(RuntimeExecutionMode executionMode, String tableName, boolean ignoreException, String manualCause, FlinkTestBase.ExpectedResult expectedResult) {
        super.prepareEnv(executionMode, tableName, ignoreException, manualCause, expectedResult);
        if (expectedResult.success) {
            if (manualCause.contains("create file store path")) {
                Assertions.assertThat((boolean)Paths.get(this.rootPath, this.relativeTablePath(this.tableIdentifier)).toFile().mkdirs()).isTrue();
            }
            this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).ifPresent(catalog -> {
                try {
                    catalog.dropTable(this.tableIdentifier.toObjectPath(), false);
                }
                catch (TableNotExistException tableNotExistException) {
                    // empty catch block
                }
            });
        } else {
            this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).ifPresent(catalog -> {
                try {
                    catalog.createTable(this.tableIdentifier.toObjectPath(), (CatalogBaseTable)this.resolvedTable, false);
                }
                catch (DatabaseNotExistException | TableAlreadyExistException throwable) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    protected void testCore() {
        String ddl = ShowCreateUtil.buildShowCreateTable(this.resolvedTable, this.tableIdentifier, this.ignoreException);
        if (this.expectedResult.success) {
            this.tEnv.executeSql(ddl);
            Assertions.assertThat((Optional)((TableEnvironmentImpl)this.tEnv).getCatalogManager().getTable(this.tableIdentifier)).isPresent();
            Assertions.assertThat((File)Paths.get(this.rootPath, this.relativeTablePath(this.tableIdentifier)).toFile()).exists();
        } else {
            Assertions.assertThat((boolean)this.ignoreException).isFalse();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql(ddl)).getCause().isInstanceOf(this.expectedResult.expectedType)).hasMessageContaining(this.expectedResult.expectedMessage);
            Assertions.assertThat((Optional)((TableEnvironmentImpl)this.tEnv).getCatalogManager().getTable(this.tableIdentifier)).isPresent();
        }
    }

    private static List<Arguments> data() {
        ArrayList<Arguments> args = new ArrayList<Arguments>();
        args.add(Arguments.arguments((Object[])new Object[]{RuntimeExecutionMode.STREAMING, "table_" + UUID.randomUUID(), true, "", new FlinkTestBase.ExpectedResult().success(true)}));
        args.add(Arguments.arguments((Object[])new Object[]{RuntimeExecutionMode.STREAMING, "table_" + UUID.randomUUID(), false, "", new FlinkTestBase.ExpectedResult().success(true)}));
        args.add(Arguments.arguments((Object[])new Object[]{RuntimeExecutionMode.STREAMING, "table_" + UUID.randomUUID(), false, "create file store path", new FlinkTestBase.ExpectedResult().success(true)}));
        String tableName = "table_" + UUID.randomUUID();
        args.add(Arguments.arguments((Object[])new Object[]{RuntimeExecutionMode.STREAMING, tableName, false, "", new FlinkTestBase.ExpectedResult().success(false).expectedType(TableAlreadyExistException.class).expectedMessage(String.format("Table (or view) %s already exists in Catalog %s.", ObjectIdentifier.of((String)"catalog", (String)"default", (String)tableName).toObjectPath().getFullName(), "catalog"))}));
        return args;
    }
}

