/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.paimon.flink.FlinkTestBase;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.provider.Arguments;

public class DropTableITCase
extends FlinkTestBase {
    @Override
    public void prepareEnv(RuntimeExecutionMode executionMode, String tableName, boolean ignoreException, String manualCause, FlinkTestBase.ExpectedResult expectedResult) {
        super.prepareEnv(executionMode, tableName, ignoreException, manualCause, expectedResult);
        ((TableEnvironmentImpl)this.tEnv).getCatalogManager().createTable((CatalogBaseTable)this.resolvedTable, this.tableIdentifier, false);
        if (expectedResult.success) {
            if (ignoreException) {
                this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).ifPresent(catalog -> {
                    try {
                        catalog.dropTable(this.tableIdentifier.toObjectPath(), false);
                    }
                    catch (TableNotExistException tableNotExistException) {
                        // empty catch block
                    }
                });
                this.deleteTablePath();
            }
        } else if (manualCause.contains("delete file store path")) {
            this.deleteTablePath();
        } else {
            this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).ifPresent(catalog -> {
                try {
                    catalog.dropTable(this.tableIdentifier.toObjectPath(), false);
                }
                catch (TableNotExistException tableNotExistException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    protected void testCore() {
        String ddl = String.format("DROP TABLE%s%s\n", this.ignoreException ? " IF EXISTS " : " ", this.tableIdentifier.asSerializableString());
        if (this.expectedResult.success) {
            this.tEnv.executeSql(ddl);
            Assertions.assertThat((Optional)((TableEnvironmentImpl)this.tEnv).getCatalogManager().getTable(this.tableIdentifier)).isNotPresent();
            Assertions.assertThat((File)Paths.get(this.rootPath, this.relativeTablePath(this.tableIdentifier)).toFile()).doesNotExist();
        } else {
            Assertions.assertThat((boolean)this.ignoreException).isFalse();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql(ddl)).isInstanceOf(this.expectedResult.expectedType)).hasMessageContaining(this.expectedResult.expectedMessage);
            Assertions.assertThat((Optional)((TableEnvironmentImpl)this.tEnv).getCatalogManager().getTable(this.tableIdentifier)).isNotPresent();
        }
    }

    private static List<Arguments> data() {
        ArrayList<Arguments> args = new ArrayList<Arguments>();
        args.add(Arguments.arguments((Object[])new Object[]{RuntimeExecutionMode.STREAMING, "table_" + UUID.randomUUID(), true, "", new FlinkTestBase.ExpectedResult().success(true)}));
        args.add(Arguments.arguments((Object[])new Object[]{RuntimeExecutionMode.STREAMING, "table_" + UUID.randomUUID(), false, "", new FlinkTestBase.ExpectedResult().success(true)}));
        String tableName = "table_" + UUID.randomUUID();
        args.add(Arguments.arguments((Object[])new Object[]{RuntimeExecutionMode.STREAMING, tableName, false, "delete file store path", new FlinkTestBase.ExpectedResult().success(false).expectedType(ValidationException.class).expectedMessage(String.format("Table with identifier '%s' does not exist.", ObjectIdentifier.of((String)"catalog", (String)"default", (String)tableName).asSummaryString()))}));
        tableName = "table_" + UUID.randomUUID();
        args.add(Arguments.arguments((Object[])new Object[]{RuntimeExecutionMode.STREAMING, tableName, false, "drop table", new FlinkTestBase.ExpectedResult().success(false).expectedType(ValidationException.class).expectedMessage(String.format("Table with identifier '%s' does not exist.", ObjectIdentifier.of((String)"catalog", (String)"default", (String)tableName).asSummaryString()))}));
        return args;
    }
}

