/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class GlobalDynamicBucketTableITCase
extends CatalogITCaseBase {
    @Override
    protected List<String> ddl() {
        return Arrays.asList("CREATE TABLE IF NOT EXISTS T (pt INT, pk INT, v INT, PRIMARY KEY (pk) NOT ENFORCED) PARTITIONED BY (pt) WITH ( 'bucket'='-1',  'dynamic-bucket.target-row-num'='3' )", "CREATE TABLE IF NOT EXISTS partial_update_t (pt INT, pk INT, v1 INT, v2 INT, PRIMARY KEY (pk) NOT ENFORCED) PARTITIONED BY (pt) WITH ( 'merge-engine'='partial-update',  'bucket'='-1',  'dynamic-bucket.target-row-num'='3' )", "CREATE TABLE IF NOT EXISTS first_row_t (pt INT, pk INT, v INT, PRIMARY KEY (pk) NOT ENFORCED) PARTITIONED BY (pt) WITH ( 'merge-engine'='first-row',  'changelog-producer'='lookup',  'bucket'='-1',  'dynamic-bucket.target-row-num'='3' )");
    }

    @Test
    public void testBulkLoad() {
        this.sql("INSERT INTO T VALUES (1, 1, 1), (2, 1, 2), (1, 3, 3), (2, 4, 4), (3, 3, 5)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{2, 1, 2}), Row.of((Object[])new Object[]{3, 3, 5}), Row.of((Object[])new Object[]{2, 4, 4})});
        this.sql("INSERT INTO partial_update_t VALUES (1, 1, 1, 1), (2, 1, 2, 3), (1, 3, 3, 3), (2, 4, 4, 4)", new Object[0]);
        this.sql("INSERT INTO partial_update_t VALUES (3, 3, CAST(NULL AS INT), 5)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM partial_update_t", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1, 2, 3}), Row.of((Object[])new Object[]{2, 4, 4, 4}), Row.of((Object[])new Object[]{1, 3, 3, 5})});
        this.sql("INSERT INTO first_row_t VALUES (1, 1, 1), (2, 1, 2), (1, 3, 3), (2, 4, 4), (3, 3, 5)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM first_row_t", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1, 1}), Row.of((Object[])new Object[]{1, 3, 3}), Row.of((Object[])new Object[]{2, 4, 4})});
    }

    @Test
    public void testBulkLoad2() {
        this.sql("INSERT INTO partial_update_t VALUES (1, 3, 1, 1), (2, 3, 2, 3), (1, 3, 3, 3), (2, 3, 4, 4)", new Object[0]);
        this.sql("INSERT INTO partial_update_t VALUES (3, 3, CAST(NULL AS INT), 5)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM partial_update_t", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 3, 4, 5})});
    }

    @Test
    public void testWriteRead() {
        this.sql("INSERT INTO T VALUES (1, 1, 1), (1, 2, 2), (1, 3, 3), (1, 4, 4), (1, 5, 5)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1, 1}), Row.of((Object[])new Object[]{1, 2, 2}), Row.of((Object[])new Object[]{1, 3, 3}), Row.of((Object[])new Object[]{1, 4, 4}), Row.of((Object[])new Object[]{1, 5, 5})});
        this.sql("INSERT INTO T VALUES (1, 3, 33), (1, 1, 11)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1, 11}), Row.of((Object[])new Object[]{1, 2, 2}), Row.of((Object[])new Object[]{1, 3, 33}), Row.of((Object[])new Object[]{1, 4, 4}), Row.of((Object[])new Object[]{1, 5, 5})});
        Assertions.assertThat(this.sql("SELECT DISTINCT bucket FROM T$files", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{0}), Row.of((Object[])new Object[]{1})});
        this.sql("INSERT INTO T VALUES (2, 1, 2), (2, 2, 3)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{2, 1, 2}), Row.of((Object[])new Object[]{2, 2, 3}), Row.of((Object[])new Object[]{1, 3, 33}), Row.of((Object[])new Object[]{1, 4, 4}), Row.of((Object[])new Object[]{1, 5, 5})});
    }

    @Test
    public void testWriteWithAssignerParallelism() {
        this.sql("INSERT INTO T /*+ OPTIONS('dynamic-bucket.assigner-parallelism'='3') */ VALUES (1, 1, 1), (1, 2, 2), (1, 3, 3), (1, 4, 4), (1, 5, 5)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT DISTINCT bucket FROM T$files", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{0}), Row.of((Object[])new Object[]{1}), Row.of((Object[])new Object[]{2})});
    }

    @Test
    public void testLargeRecords() {
        this.sql("create table large_t (pt int, k int, v int, primary key (k) not enforced) partitioned by (pt) with ('bucket'='-1', 'rocksdb.compaction.level.target-file-size-base'='2 kb', 'dynamic-bucket.target-row-num'='10000')", new Object[0]);
        this.sql("create temporary table src (pt int, k int, v int) with ('connector'='datagen', 'number-of-rows'='100000', 'fields.k.min'='0', 'fields.k.max'='100000', 'fields.pt.min'='0', 'fields.pt.max'='1')", new Object[0]);
        this.sql("insert into large_t select * from src", new Object[0]);
        this.sql("insert into large_t select * from src", new Object[0]);
        Assertions.assertThat(this.sql("select k, count(*) from large_t group by k having count(*) > 1", new Object[0])).isEmpty();
    }
}

