/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Collections;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.util.ReadWriteTableTestUtil;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.TagManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BranchActionITCase
extends ActionITCaseBase {
    BranchActionITCase() {
    }

    @Test
    void testCreateAndDeleteBranch() throws Exception {
        ReadWriteTableTestUtil.init(this.warehouse);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"k", "v"});
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Hello")));
        this.writeData(this.rowData(3L, BinaryString.fromString((String)"Paimon")));
        TagManager tagManager = new TagManager(table.fileIO(), table.location());
        this.callProcedure(String.format("CALL sys.create_tag('%s.%s', 'tag2', 2, '5 d')", this.database, this.tableName));
        Assertions.assertThat((boolean)tagManager.tagExists("tag2")).isTrue();
        BranchManager branchManager = table.branchManager();
        this.callProcedure(String.format("CALL sys.create_branch('%s.%s', 'branch_name', 'tag2')", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("branch_name")).isTrue();
        this.callProcedure(String.format("CALL sys.delete_branch('%s.%s', 'branch_name')", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("branch_name")).isFalse();
    }

    @Test
    void testCreateAndDeleteBranchWithSnapshotId() throws Exception {
        ReadWriteTableTestUtil.init(this.warehouse);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"k", "v"});
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Hello")));
        this.writeData(this.rowData(3L, BinaryString.fromString((String)"Paimon")));
        BranchManager branchManager = table.branchManager();
        this.callProcedure(String.format("CALL sys.create_branch('%s.%s', 'branch_name_with_snapshotId', 2)", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("branch_name_with_snapshotId")).isTrue();
        branchManager.branches();
        this.callProcedure(String.format("CALL sys.delete_branch('%s.%s', 'branch_name_with_snapshotId')", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("branch_name_with_snapshotId")).isFalse();
    }

    @Test
    void testCreateAndDeleteEmptyBranch() throws Exception {
        ReadWriteTableTestUtil.init(this.warehouse);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"k", "v"});
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Hello")));
        this.writeData(this.rowData(3L, BinaryString.fromString((String)"Paimon")));
        BranchManager branchManager = table.branchManager();
        this.callProcedure(String.format("CALL sys.create_branch('%s.%s', 'empty_branch_name')", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("empty_branch_name")).isTrue();
        this.callProcedure(String.format("CALL sys.delete_branch('%s.%s', 'empty_branch_name')", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("empty_branch_name")).isFalse();
    }
}

