/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.RemoveOrphanFilesAction;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class RemoveOrphanFilesActionITCase
extends ActionITCaseBase {
    @Test
    public void testRunWithoutException() throws Exception {
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"k", "v"});
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("remove_orphan_files", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName));
        RemoveOrphanFilesAction action1 = this.createAction(RemoveOrphanFilesAction.class, args);
        Assertions.assertThatCode(() -> ((RemoveOrphanFilesAction)action1).run()).doesNotThrowAnyException();
        args.add("--older_than");
        args.add("2023-12-31 23:59:59");
        RemoveOrphanFilesAction action2 = this.createAction(RemoveOrphanFilesAction.class, args);
        Assertions.assertThatCode(() -> ((RemoveOrphanFilesAction)action2).run()).doesNotThrowAnyException();
        String withoutOlderThan = String.format("CALL sys.remove_orphan_files('%s.%s')", this.database, this.tableName);
        Assertions.assertThatCode(() -> this.callProcedure(withoutOlderThan)).doesNotThrowAnyException();
        String withOlderThan = String.format("CALL sys.remove_orphan_files('%s.%s', '2023-12-31 23:59:59')", this.database, this.tableName);
        Assertions.assertThatCode(() -> this.callProcedure(withOlderThan)).doesNotThrowAnyException();
    }
}

