/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.memory.HeapMemorySegmentPool;
import org.apache.paimon.memory.MemoryOwner;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.mergetree.compact.DeduplicateMergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.operation.KeyValueFileStoreWrite;
import org.apache.paimon.operation.MergeFileSplitRead;
import org.apache.paimon.operation.RawFileSplitRead;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.KeyValueTableRead;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FieldsComparator;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.RecordWriter;
import org.apache.paimon.utils.SnapshotManager;

public class TestChangelogDataReadWrite {
    private static final RowType KEY_TYPE = new RowType(Collections.singletonList(new DataField(0, "k", (DataType)new BigIntType())));
    private static final RowType VALUE_TYPE = new RowType(Collections.singletonList(new DataField(0, "v", (DataType)new BigIntType())));
    private static final Comparator<InternalRow> COMPARATOR = Comparator.comparingLong(o -> o.getLong(0));
    private static final RecordEqualiser EQUALISER = (RecordEqualiser & Serializable)(row1, row2) -> row1.getLong(0) == row2.getLong(0);
    private static final KeyValueFieldsExtractor EXTRACTOR = new KeyValueFieldsExtractor(){

        public List<DataField> keyFields(TableSchema schema) {
            return Collections.singletonList(new DataField(0, "k", (DataType)new BigIntType(false)));
        }

        public List<DataField> valueFields(TableSchema schema) {
            return Collections.singletonList(new DataField(0, "v", (DataType)new BigIntType(false)));
        }
    };
    private final FileFormat avro = FileFormat.fromIdentifier((String)"avro", (Options)new Options());
    private final Path tablePath;
    private final FileStorePathFactory pathFactory;
    private final SnapshotManager snapshotManager;
    private final String commitUser;

    public TestChangelogDataReadWrite(String root) {
        this.tablePath = new Path(root);
        this.pathFactory = new FileStorePathFactory(this.tablePath, RowType.of((DataType[])new DataType[]{new IntType()}), "default", ((CoreOptions.FileFormatType)CoreOptions.FILE_FORMAT.defaultValue()).toString());
        this.snapshotManager = new SnapshotManager((FileIO)LocalFileIO.create(), new Path(root));
        this.commitUser = UUID.randomUUID().toString();
    }

    public TableRead createReadWithKey() {
        SchemaManager schemaManager = new SchemaManager((FileIO)LocalFileIO.create(), this.tablePath);
        CoreOptions options = new CoreOptions(new HashMap());
        TableSchema schema = schemaManager.schema(0L);
        MergeFileSplitRead read = new MergeFileSplitRead(options, schema, KEY_TYPE, VALUE_TYPE, COMPARATOR, DeduplicateMergeFunction.factory(), KeyValueFileReaderFactory.builder((FileIO)LocalFileIO.create(), (SchemaManager)schemaManager, (TableSchema)schema, (RowType)KEY_TYPE, (RowType)VALUE_TYPE, ignore -> this.avro, (FileStorePathFactory)this.pathFactory, (KeyValueFieldsExtractor)EXTRACTOR, (CoreOptions)options));
        RawFileSplitRead rawFileRead = new RawFileSplitRead((FileIO)LocalFileIO.create(), schemaManager, schema, VALUE_TYPE, FileFormatDiscover.of((CoreOptions)options), this.pathFactory, options.fileIndexReadEnabled());
        return new KeyValueTableRead(() -> read, () -> rawFileRead, null);
    }

    public List<DataFileMeta> writeFiles(BinaryRow partition, int bucket, List<Tuple2<Long, Long>> kvs) throws Exception {
        RecordWriter<KeyValue> writer = this.createMergeTreeWriter(partition, bucket);
        for (Tuple2<Long, Long> tuple2 : kvs) {
            writer.write((Object)new KeyValue().replace((InternalRow)GenericRow.of((Object[])new Object[]{tuple2.f0}), RowKind.INSERT, (InternalRow)GenericRow.of((Object[])new Object[]{tuple2.f1})));
        }
        List files = writer.prepareCommit(true).newFilesIncrement().newFiles();
        writer.close();
        return new ArrayList<DataFileMeta>(files);
    }

    public RecordWriter<KeyValue> createMergeTreeWriter(BinaryRow partition, int bucket) {
        CoreOptions options = new CoreOptions(Collections.singletonMap(CoreOptions.FILE_FORMAT.key(), "avro"));
        HashMap<String, FileStorePathFactory> pathFactoryMap = new HashMap<String, FileStorePathFactory>();
        pathFactoryMap.put("avro", this.pathFactory);
        SchemaManager schemaManager = new SchemaManager((FileIO)LocalFileIO.create(), this.tablePath);
        RecordWriter writer = new KeyValueFileStoreWrite((FileIO)LocalFileIO.create(), (SchemaManager)schemaManager, (TableSchema)schemaManager.schema((long)0L), (String)this.commitUser, (RowType)TestChangelogDataReadWrite.KEY_TYPE, (RowType)TestChangelogDataReadWrite.VALUE_TYPE, (Supplier<Comparator>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$createMergeTreeWriter$4(), ()Ljava/util/Comparator;)(), (Supplier<FieldsComparator>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$createMergeTreeWriter$5(), ()Lorg/apache/paimon/utils/FieldsComparator;)(), (Supplier<RecordEqualiser>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$createMergeTreeWriter$6(), ()Lorg/apache/paimon/codegen/RecordEqualiser;)(), (MergeFunctionFactory)DeduplicateMergeFunction.factory(), (FileStorePathFactory)this.pathFactory, pathFactoryMap, (SnapshotManager)this.snapshotManager, null, null, null, (CoreOptions)options, (KeyValueFieldsExtractor)TestChangelogDataReadWrite.EXTRACTOR, (String)this.tablePath.getName()).createWriterContainer((BinaryRow)partition, (int)bucket, (boolean)true).writer;
        ((MemoryOwner)writer).setMemoryPool((MemorySegmentPool)new HeapMemorySegmentPool(options.writeBufferSize(), options.pageSize()));
        return writer;
    }

    private static /* synthetic */ RecordEqualiser lambda$createMergeTreeWriter$6() {
        return EQUALISER;
    }

    private static /* synthetic */ FieldsComparator lambda$createMergeTreeWriter$5() {
        return null;
    }

    private static /* synthetic */ Comparator lambda$createMergeTreeWriter$4() {
        return COMPARATOR;
    }
}

