/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import java.util.Random;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.utils.InternalRowTypeSerializer;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class InternalRowSerializerTest {
    private static final Random RANDOM = new Random();
    private static final RowType rowType = RowType.builder().field("a", (DataType)DataTypes.STRING()).field("b", (DataType)DataTypes.INT()).field("c", (DataType)DataTypes.BIGINT()).build();

    @Test
    public void testSerializeAndDeserilize() throws Exception {
        DataOutputSerializer dataOutputSerializer = new DataOutputSerializer(100);
        InternalRowTypeSerializer internalRowTypeSerializer = new InternalRowTypeSerializer(rowType.getFieldTypes().toArray(new DataType[0]));
        GenericRow row = GenericRow.of((Object[])new Object[]{this.randomString(), RANDOM.nextInt(), RANDOM.nextLong()});
        internalRowTypeSerializer.serialize((InternalRow)row, (DataOutputView)dataOutputSerializer);
        InternalRow row1 = internalRowTypeSerializer.deserialize((DataInputView)new DataInputDeserializer(dataOutputSerializer.wrapAsByteBuffer()));
        Assertions.assertThat((Comparable)row.getString(0)).isEqualTo((Object)row1.getString(0));
        Assertions.assertThat((int)row.getInt(1)).isEqualTo(row1.getInt(1));
        Assertions.assertThat((long)row.getLong(2)).isEqualTo(row1.getLong(2));
    }

    @Test
    public void testEqual() {
        InternalRowTypeSerializer internalRowTypeSerializer = new InternalRowTypeSerializer(rowType.getFieldTypes().toArray(new DataType[0]));
        Assertions.assertThat((Object)internalRowTypeSerializer).isEqualTo((Object)internalRowTypeSerializer.duplicate());
    }

    @Test
    public void testCopyFromView() {
        InternalRowTypeSerializer internalRowTypeSerializer = new InternalRowTypeSerializer(rowType.getFieldTypes().toArray(new DataType[0]));
        GenericRow row = GenericRow.of((Object[])new Object[]{this.randomString(), RANDOM.nextInt(), RANDOM.nextLong()});
        InternalRow row1 = internalRowTypeSerializer.copy((InternalRow)row);
        Assertions.assertThat((Comparable)row.getString(0)).isEqualTo((Object)row1.getString(0));
        Assertions.assertThat((int)row.getInt(1)).isEqualTo(row1.getInt(1));
        Assertions.assertThat((long)row.getLong(2)).isEqualTo(row1.getLong(2));
    }

    private BinaryString randomString() {
        int length = RANDOM.nextInt(100);
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = (byte)(65 + RANDOM.nextInt(26));
        }
        return BinaryString.fromBytes((byte[])buffer);
    }
}

