/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.flink.table.types.logical.RowType;

public abstract class Projection {
    private Projection() {
    }

    public abstract RowType project(RowType var1);

    public abstract boolean isNested();

    public abstract int[] toTopLevelIndexes();

    public abstract int[][] toNestedIndexes();

    public static Projection empty() {
        return EmptyProjection.INSTANCE;
    }

    public static Projection of(int[] indexes) {
        if (indexes.length == 0) {
            return Projection.empty();
        }
        return new TopLevelProjection(indexes);
    }

    public static Projection of(int[][] indexes) {
        if (indexes.length == 0) {
            return Projection.empty();
        }
        return new NestedProjection(indexes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Projection)) {
            return false;
        }
        Projection other = (Projection)o;
        if (!this.isNested() && !other.isNested()) {
            return Arrays.equals(this.toTopLevelIndexes(), other.toTopLevelIndexes());
        }
        return Arrays.deepEquals((Object[])this.toNestedIndexes(), (Object[])other.toNestedIndexes());
    }

    public int hashCode() {
        if (this.isNested()) {
            return Arrays.deepHashCode((Object[])this.toNestedIndexes());
        }
        return Arrays.hashCode(this.toTopLevelIndexes());
    }

    public String toString() {
        if (this.isNested()) {
            return "Nested projection = " + Arrays.deepToString((Object[])this.toNestedIndexes());
        }
        return "Top level projection = " + Arrays.toString(this.toTopLevelIndexes());
    }

    private static class TopLevelProjection
    extends Projection {
        final int[] projection;

        TopLevelProjection(int[] projection) {
            this.projection = projection;
        }

        @Override
        public RowType project(RowType dataType) {
            return new NestedProjection(this.toNestedIndexes()).project(dataType);
        }

        @Override
        public boolean isNested() {
            return false;
        }

        @Override
        public int[] toTopLevelIndexes() {
            return this.projection;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int[][] toNestedIndexes() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ int[][] lambda$toNestedIndexes$1(int x$0) {
            return new int[x$0][];
        }
    }

    private static class NestedProjection
    extends Projection {
        final int[][] projection;
        final boolean nested;

        NestedProjection(int[][] projection) {
            this.projection = projection;
            this.nested = Arrays.stream(projection).anyMatch(arr -> ((int[])arr).length > 1);
        }

        @Override
        public RowType project(RowType rowType) {
            ArrayList<RowType.RowField> updatedFields = new ArrayList<RowType.RowField>();
            HashSet<String> nameDomain = new HashSet<String>();
            int duplicateCount = 0;
            for (int[] indexPath : this.projection) {
                RowType.RowField field = (RowType.RowField)rowType.getFields().get(indexPath[0]);
                StringBuilder builder = new StringBuilder((String)rowType.getFieldNames().get(indexPath[0]));
                for (int index = 1; index < indexPath.length; ++index) {
                    RowType rowtype = (RowType)field.getType();
                    builder.append("_").append((String)rowtype.getFieldNames().get(indexPath[index]));
                    field = (RowType.RowField)rowtype.getFields().get(indexPath[index]);
                }
                String path = builder.toString();
                while (nameDomain.contains(path)) {
                    path = builder.append("_$").append(duplicateCount++).toString();
                }
                updatedFields.add(new RowType.RowField(path, field.getType(), (String)field.getDescription().orElse(null)));
                nameDomain.add(path);
            }
            return new RowType(rowType.isNullable(), updatedFields);
        }

        @Override
        public boolean isNested() {
            return this.nested;
        }

        @Override
        public int[] toTopLevelIndexes() {
            if (this.isNested()) {
                throw new IllegalStateException("Cannot convert a nested projection to a top level projection");
            }
            return Arrays.stream(this.projection).mapToInt(arr -> arr[0]).toArray();
        }

        @Override
        public int[][] toNestedIndexes() {
            return this.projection;
        }
    }

    private static class EmptyProjection
    extends Projection {
        static final EmptyProjection INSTANCE = new EmptyProjection();

        private EmptyProjection() {
        }

        @Override
        public RowType project(RowType dataType) {
            return new NestedProjection(this.toNestedIndexes()).project(dataType);
        }

        @Override
        public boolean isNested() {
            return false;
        }

        @Override
        public int[] toTopLevelIndexes() {
            return new int[0];
        }

        @Override
        public int[][] toNestedIndexes() {
            return new int[0][];
        }
    }
}

