/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Collections;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.flink.utils.TableMigrationUtils;
import org.apache.paimon.hive.HiveCatalog;

public class MigrateFileProcedure
extends ProcedureBase {
    @Override
    public String identifier() {
        return "migrate_file";
    }

    public String[] call(ProcedureContext procedureContext, String connector, String sourceTablePath, String targetPaimonTablePath) throws Exception {
        if (!(this.catalog instanceof HiveCatalog)) {
            throw new IllegalArgumentException("Only support Hive Catalog");
        }
        Identifier sourceTableId = Identifier.fromString(sourceTablePath);
        Identifier targetTableId = Identifier.fromString(targetPaimonTablePath);
        if (!this.catalog.tableExists(targetTableId)) {
            throw new IllegalArgumentException("Target paimon table does not exist: " + targetPaimonTablePath);
        }
        TableMigrationUtils.getImporter(connector, (HiveCatalog)this.catalog, sourceTableId.getDatabaseName(), sourceTableId.getObjectName(), targetTableId.getDatabaseName(), targetTableId.getObjectName(), Collections.emptyMap()).executeMigrate();
        return new String[]{"Success"};
    }
}

