/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.index;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.paimon.flink.sink.index.KeyPartOrRow;
import org.apache.paimon.flink.utils.InternalTypeSerializer;

public class KeyWithRowSerializer<T>
extends InternalTypeSerializer<Tuple2<KeyPartOrRow, T>> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<T> keyPartSerializer;
    private final TypeSerializer<T> rowSerializer;

    public KeyWithRowSerializer(TypeSerializer<T> keyPartSerializer, TypeSerializer<T> rowSerializer) {
        this.keyPartSerializer = keyPartSerializer;
        this.rowSerializer = rowSerializer;
    }

    public TypeSerializer<Tuple2<KeyPartOrRow, T>> duplicate() {
        return new KeyWithRowSerializer<T>(this.keyPartSerializer.duplicate(), this.rowSerializer.duplicate());
    }

    public Tuple2<KeyPartOrRow, T> createInstance() {
        return new Tuple2();
    }

    private TypeSerializer<T> serializer(KeyPartOrRow keyPartOrRow) {
        return keyPartOrRow == KeyPartOrRow.KEY_PART ? this.keyPartSerializer : this.rowSerializer;
    }

    public Tuple2<KeyPartOrRow, T> copy(Tuple2<KeyPartOrRow, T> from) {
        return new Tuple2(from.f0, this.serializer((KeyPartOrRow)((Object)from.f0)).copy(from.f1));
    }

    public void serialize(Tuple2<KeyPartOrRow, T> record, DataOutputView target) throws IOException {
        target.writeByte((int)((KeyPartOrRow)((Object)record.f0)).toByteValue());
        this.serializer((KeyPartOrRow)((Object)record.f0)).serialize(record.f1, target);
    }

    public Tuple2<KeyPartOrRow, T> deserialize(DataInputView source) throws IOException {
        KeyPartOrRow keyPartOrRow = KeyPartOrRow.fromByteValue(source.readByte());
        Object row = this.serializer(keyPartOrRow).deserialize(source);
        return new Tuple2((Object)keyPartOrRow, row);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KeyWithRowSerializer that = (KeyWithRowSerializer)((Object)o);
        return Objects.equals(this.keyPartSerializer, that.keyPartSerializer) && Objects.equals(this.rowSerializer, that.rowSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.keyPartSerializer, this.rowSerializer);
    }
}

