/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.ColumnarRow;
import org.apache.paimon.data.columnar.ColumnarRowIterator;
import org.apache.paimon.data.columnar.VectorizedColumnBatch;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.OrcFormatReaderContext;
import org.apache.paimon.format.fs.HadoopReadOnlyFileSystem;
import org.apache.paimon.format.orc.SerializableHadoopConfigWrapper;
import org.apache.paimon.format.orc.filter.OrcFilters;
import org.apache.paimon.format.orc.reader.AbstractOrcColumnVector;
import org.apache.paimon.format.orc.reader.OrcSplitReaderUtil;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.paimon.shade.org.apache.orc.OrcConf;
import org.apache.paimon.shade.org.apache.orc.OrcFile;
import org.apache.paimon.shade.org.apache.orc.Reader;
import org.apache.paimon.shade.org.apache.orc.RecordReader;
import org.apache.paimon.shade.org.apache.orc.StripeInformation;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Pool;
import org.apache.paimon.utils.Preconditions;

public class OrcReaderFactory
implements FormatReaderFactory {
    private static final long serialVersionUID = 1L;
    protected final SerializableHadoopConfigWrapper hadoopConfigWrapper;
    protected final TypeDescription schema;
    private final RowType tableType;
    protected final List<OrcFilters.Predicate> conjunctPredicates;
    protected final int batchSize;

    public OrcReaderFactory(Configuration hadoopConfig, RowType readType, List<OrcFilters.Predicate> conjunctPredicates, int batchSize) {
        this.hadoopConfigWrapper = new SerializableHadoopConfigWrapper((Configuration)Preconditions.checkNotNull((Object)hadoopConfig));
        this.schema = OrcSplitReaderUtil.toOrcType((DataType)readType);
        this.tableType = readType;
        this.conjunctPredicates = (List)Preconditions.checkNotNull(conjunctPredicates);
        this.batchSize = batchSize;
    }

    public OrcVectorizedReader createReader(FormatReaderFactory.Context context) throws IOException {
        int poolSize = context instanceof OrcFormatReaderContext ? ((OrcFormatReaderContext)context).poolSize() : 1;
        Pool<OrcReaderBatch> poolOfBatches = this.createPoolOfBatches(context.filePath(), poolSize);
        RecordReader orcReader = OrcReaderFactory.createRecordReader(this.hadoopConfigWrapper.getHadoopConfig(), this.schema, this.conjunctPredicates, context.fileIO(), context.filePath(), 0L, context.fileSize());
        return new OrcVectorizedReader(orcReader, poolOfBatches);
    }

    public OrcReaderBatch createReaderBatch(Path filePath, VectorizedRowBatch orcBatch, Pool.Recycler<OrcReaderBatch> recycler) {
        List tableFieldNames = this.tableType.getFieldNames();
        List tableFieldTypes = this.tableType.getFieldTypes();
        ColumnVector[] vectors = new ColumnVector[this.tableType.getFieldCount()];
        for (int i = 0; i < vectors.length; ++i) {
            String name = (String)tableFieldNames.get(i);
            DataType type = (DataType)tableFieldTypes.get(i);
            vectors[i] = AbstractOrcColumnVector.createPaimonVector(orcBatch.cols[tableFieldNames.indexOf(name)], type);
        }
        return new OrcReaderBatch(filePath, orcBatch, new VectorizedColumnBatch(vectors), recycler);
    }

    private Pool<OrcReaderBatch> createPoolOfBatches(Path filePath, int numBatches) {
        Pool pool = new Pool(numBatches);
        for (int i = 0; i < numBatches; ++i) {
            VectorizedRowBatch orcBatch = OrcReaderFactory.createBatchWrapper(this.schema, this.batchSize / numBatches);
            OrcReaderBatch batch = this.createReaderBatch(filePath, orcBatch, (Pool.Recycler<OrcReaderBatch>)pool.recycler());
            pool.add((Object)batch);
        }
        return pool;
    }

    private static RecordReader createRecordReader(Configuration conf, TypeDescription schema, List<OrcFilters.Predicate> conjunctPredicates, FileIO fileIO, Path path, long splitStart, long splitLength) throws IOException {
        Reader orcReader = OrcReaderFactory.createReader(conf, fileIO, path);
        try {
            Pair<Long, Long> offsetAndLength = OrcReaderFactory.getOffsetAndLengthForSplit(splitStart, splitLength, orcReader.getStripes());
            Reader.Options options = new Reader.Options().schema(schema).range((Long)offsetAndLength.getLeft(), (Long)offsetAndLength.getRight()).useZeroCopy(OrcConf.USE_ZEROCOPY.getBoolean(conf)).skipCorruptRecords(OrcConf.SKIP_CORRUPT_DATA.getBoolean(conf)).tolerateMissingSchema(OrcConf.TOLERATE_MISSING_SCHEMA.getBoolean(conf));
            if (!conjunctPredicates.isEmpty()) {
                SearchArgument.Builder b = SearchArgumentFactory.newBuilder();
                b = b.startAnd();
                for (OrcFilters.Predicate predicate : conjunctPredicates) {
                    predicate.add(b);
                }
                b = b.end();
                options.searchArgument(b.build(), new String[0]);
            }
            RecordReader orcRowsReader = orcReader.rows(options);
            schema.getId();
            return orcRowsReader;
        }
        catch (IOException e) {
            IOUtils.closeQuietly((AutoCloseable)orcReader);
            throw e;
        }
    }

    private static VectorizedRowBatch createBatchWrapper(TypeDescription schema, int batchSize) {
        return schema.createRowBatch(batchSize);
    }

    private static boolean nextBatch(RecordReader reader, VectorizedRowBatch rowBatch) throws IOException {
        return reader.nextBatch(rowBatch);
    }

    private static Pair<Long, Long> getOffsetAndLengthForSplit(long splitStart, long splitLength, List<StripeInformation> stripes) {
        long splitEnd = splitStart + splitLength;
        long readStart = Long.MAX_VALUE;
        long readEnd = Long.MIN_VALUE;
        for (StripeInformation s : stripes) {
            if (splitStart > s.getOffset() || s.getOffset() >= splitEnd) continue;
            readStart = Math.min(readStart, s.getOffset());
            readEnd = Math.max(readEnd, s.getOffset() + s.getLength());
        }
        if (readStart < Long.MAX_VALUE) {
            return Pair.of((Object)readStart, (Object)(readEnd - readStart));
        }
        return Pair.of((Object)0L, (Object)0L);
    }

    public static Reader createReader(Configuration conf, FileIO fileIO, Path path) throws IOException {
        org.apache.hadoop.fs.Path hPath = new org.apache.hadoop.fs.Path(path.toUri());
        OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions(conf);
        readerOptions.filesystem(new HadoopReadOnlyFileSystem(fileIO));
        return OrcFile.createReader(hPath, readerOptions);
    }

    private static final class OrcVectorizedReader
    implements org.apache.paimon.reader.RecordReader<InternalRow> {
        private final RecordReader orcReader;
        private final Pool<OrcReaderBatch> pool;

        private OrcVectorizedReader(RecordReader orcReader, Pool<OrcReaderBatch> pool) {
            this.orcReader = (RecordReader)Preconditions.checkNotNull((Object)orcReader, (String)"orcReader");
            this.pool = (Pool)Preconditions.checkNotNull(pool, (String)"pool");
        }

        @Nullable
        public RecordReader.RecordIterator<InternalRow> readBatch() throws IOException {
            OrcReaderBatch batch = this.getCachedEntry();
            VectorizedRowBatch orcVectorBatch = batch.orcVectorizedRowBatch();
            long rowNumber = this.orcReader.getRowNumber();
            if (!OrcReaderFactory.nextBatch(this.orcReader, orcVectorBatch)) {
                batch.recycle();
                return null;
            }
            return batch.convertAndGetIterator(orcVectorBatch, rowNumber);
        }

        public void close() throws IOException {
            this.orcReader.close();
        }

        private OrcReaderBatch getCachedEntry() throws IOException {
            try {
                return (OrcReaderBatch)this.pool.pollEntry();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted");
            }
        }
    }

    private static class OrcReaderBatch {
        private final VectorizedRowBatch orcVectorizedRowBatch;
        private final Pool.Recycler<OrcReaderBatch> recycler;
        private final VectorizedColumnBatch paimonColumnBatch;
        private final ColumnarRowIterator result;

        protected OrcReaderBatch(Path filePath, VectorizedRowBatch orcVectorizedRowBatch, VectorizedColumnBatch paimonColumnBatch, Pool.Recycler<OrcReaderBatch> recycler) {
            this.orcVectorizedRowBatch = (VectorizedRowBatch)Preconditions.checkNotNull((Object)orcVectorizedRowBatch);
            this.recycler = (Pool.Recycler)Preconditions.checkNotNull(recycler);
            this.paimonColumnBatch = paimonColumnBatch;
            this.result = new ColumnarRowIterator(filePath, new ColumnarRow(paimonColumnBatch), this::recycle);
        }

        public void recycle() {
            this.recycler.recycle((Object)this);
        }

        public VectorizedRowBatch orcVectorizedRowBatch() {
            return this.orcVectorizedRowBatch;
        }

        private RecordReader.RecordIterator<InternalRow> convertAndGetIterator(VectorizedRowBatch orcBatch, long rowNumber) {
            this.paimonColumnBatch.setNumRows(orcBatch.size);
            this.result.reset(rowNumber);
            return this.result;
        }
    }
}

