/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.orc.impl.writer;

import java.io.IOException;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.paimon.shade.org.apache.orc.ColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.OrcFile;
import org.apache.paimon.shade.org.apache.orc.StripeStatistics;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.shade.org.apache.orc.impl.writer.BinaryTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.BooleanTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.ByteTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.CharTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.DateTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.Decimal64TreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.DecimalTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.DoubleTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.EncryptionTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.FloatTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.IntegerTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.ListTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.MapTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.StringTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.StructTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.TimestampTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.UnionTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.VarcharTreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.WriterContext;
import org.apache.paimon.shade.org.apache.orc.impl.writer.WriterEncryptionVariant;

public interface TreeWriter {
    public long estimateMemory();

    public long getRawDataSize();

    public void prepareStripe(int var1);

    public void writeRootBatch(VectorizedRowBatch var1, int var2, int var3) throws IOException;

    public void writeBatch(ColumnVector var1, int var2, int var3) throws IOException;

    public void createRowIndexEntry() throws IOException;

    public void flushStreams() throws IOException;

    public void writeStripe(int var1) throws IOException;

    public void addStripeStatistics(StripeStatistics[] var1) throws IOException;

    public void writeFileStatistics() throws IOException;

    public void getCurrentStatistics(ColumnStatistics[] var1);

    public static class Factory {
        public static TreeWriter create(TypeDescription schema, WriterEncryptionVariant encryption, WriterContext streamFactory) throws IOException {
            if (encryption == null && (encryption = streamFactory.getEncryption(schema.getId())) != null) {
                return new EncryptionTreeWriter(schema, encryption, streamFactory);
            }
            return Factory.createSubtree(schema, encryption, streamFactory);
        }

        static TreeWriter createSubtree(TypeDescription schema, WriterEncryptionVariant encryption, WriterContext streamFactory) throws IOException {
            OrcFile.Version version = streamFactory.getVersion();
            switch (schema.getCategory()) {
                case BOOLEAN: {
                    return new BooleanTreeWriter(schema, encryption, streamFactory);
                }
                case BYTE: {
                    return new ByteTreeWriter(schema, encryption, streamFactory);
                }
                case SHORT: 
                case INT: 
                case LONG: {
                    return new IntegerTreeWriter(schema, encryption, streamFactory);
                }
                case FLOAT: {
                    return new FloatTreeWriter(schema, encryption, streamFactory);
                }
                case DOUBLE: {
                    return new DoubleTreeWriter(schema, encryption, streamFactory);
                }
                case STRING: {
                    return new StringTreeWriter(schema, encryption, streamFactory);
                }
                case CHAR: {
                    return new CharTreeWriter(schema, encryption, streamFactory);
                }
                case VARCHAR: {
                    return new VarcharTreeWriter(schema, encryption, streamFactory);
                }
                case BINARY: {
                    return new BinaryTreeWriter(schema, encryption, streamFactory);
                }
                case TIMESTAMP: {
                    return new TimestampTreeWriter(schema, encryption, streamFactory, false);
                }
                case TIMESTAMP_INSTANT: {
                    return new TimestampTreeWriter(schema, encryption, streamFactory, true);
                }
                case DATE: {
                    return new DateTreeWriter(schema, encryption, streamFactory);
                }
                case DECIMAL: {
                    if (version == OrcFile.Version.UNSTABLE_PRE_2_0 && schema.getPrecision() <= 18) {
                        return new Decimal64TreeWriter(schema, encryption, streamFactory);
                    }
                    return new DecimalTreeWriter(schema, encryption, streamFactory);
                }
                case STRUCT: {
                    return new StructTreeWriter(schema, encryption, streamFactory);
                }
                case MAP: {
                    return new MapTreeWriter(schema, encryption, streamFactory);
                }
                case LIST: {
                    return new ListTreeWriter(schema, encryption, streamFactory);
                }
                case UNION: {
                    return new UnionTreeWriter(schema, encryption, streamFactory);
                }
            }
            throw new IllegalArgumentException("Bad category: " + (Object)((Object)schema.getCategory()));
        }
    }
}

