/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet.hadoop.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.shade.org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.paimon.shade.org.apache.parquet.schema.MessageType;

public final class FileMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MessageType schema;
    private final Map<String, String> keyValueMetaData;
    private final String createdBy;
    private final InternalFileDecryptor fileDecryptor;
    private final EncryptionType encryptionType;

    public FileMetaData(MessageType schema, Map<String, String> keyValueMetaData, String createdBy) {
        this(schema, keyValueMetaData, createdBy, null, null);
    }

    @Deprecated
    public FileMetaData(MessageType schema, Map<String, String> keyValueMetaData, String createdBy, InternalFileDecryptor fileDecryptor) {
        this(schema, keyValueMetaData, createdBy, null, fileDecryptor);
    }

    public FileMetaData(MessageType schema, Map<String, String> keyValueMetaData, String createdBy, EncryptionType encryptionType, InternalFileDecryptor fileDecryptor) {
        this.schema = Objects.requireNonNull(schema, "schema cannot be null");
        this.keyValueMetaData = Collections.unmodifiableMap(Objects.requireNonNull(keyValueMetaData, "keyValueMetaData cannot be null"));
        this.createdBy = createdBy;
        this.fileDecryptor = fileDecryptor;
        this.encryptionType = encryptionType;
    }

    public MessageType getSchema() {
        return this.schema;
    }

    public String toString() {
        return "FileMetaData{schema: " + this.schema + ", metadata: " + this.keyValueMetaData + "}";
    }

    public Map<String, String> getKeyValueMetaData() {
        return this.keyValueMetaData;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public InternalFileDecryptor getFileDecryptor() {
        return this.fileDecryptor;
    }

    public EncryptionType getEncryptionType() {
        return this.encryptionType;
    }

    public static enum EncryptionType {
        UNENCRYPTED,
        PLAINTEXT_FOOTER,
        ENCRYPTED_FOOTER;

    }
}

