/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.List;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.table.Table;
import org.apache.paimon.types.RowType;

public class FileStoreTestUtils {
    public static final String TABLE_NAME = "hive_test_table";
    public static final String DATABASE_NAME = "test_db";

    public static Table createFileStoreTable(Options conf, RowType rowType, List<String> partitionKeys, List<String> primaryKeys) throws Exception {
        return FileStoreTestUtils.createFileStoreTable(conf, rowType, partitionKeys, primaryKeys, null, null, false);
    }

    public static Table createFileStoreTable(Options conf, RowType rowType, List<String> partitionKeys, List<String> primaryKeys, Identifier identifier) throws Exception {
        return FileStoreTestUtils.createFileStoreTable(conf, rowType, partitionKeys, primaryKeys, identifier.getDatabaseName(), identifier.getObjectName(), false);
    }

    public static Table createFileStoreTable(Options conf, RowType rowType, List<String> partitionKeys, List<String> primaryKeys, String db, String tbl, boolean ignoreDbExist) throws Exception {
        String pdb = db == null ? DATABASE_NAME : db;
        String ptbl = tbl == null ? TABLE_NAME : tbl;
        CatalogContext catalogContext = CatalogContext.create((Options)conf);
        Catalog catalog = CatalogFactory.createCatalog((CatalogContext)catalogContext);
        catalog.createDatabase(pdb, ignoreDbExist);
        Identifier tableIdentifier = Identifier.create((String)pdb, (String)ptbl);
        catalog.createTable(tableIdentifier, new Schema(rowType.getFields(), partitionKeys, primaryKeys, conf.toMap(), ""), false);
        Table table = catalog.getTable(tableIdentifier);
        catalog.close();
        return table;
    }
}

