/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.hive.FileStoreTestUtils;
import org.apache.paimon.hive.HiveTestBase;
import org.apache.paimon.hive.PaimonStorageHandler;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.StreamTableCommit;
import org.apache.paimon.table.sink.StreamTableWrite;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class HiveReadITCase
extends HiveTestBase {
    @Test
    public void testReadExternalTableWithEmptyDataAndIgnoreCase() throws Exception {
        String tableName = "with_ignore_case";
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new DataField[]{new DataField(0, "col1", (DataType)DataTypes.INT(), "first comment"), new DataField(1, "Col2", (DataType)DataTypes.STRING(), "second comment")}), Collections.emptyList(), Collections.emptyList(), (Map)Maps.newHashMap(), "");
        Identifier identifier = Identifier.create((String)"test_db", (String)tableName);
        Path tablePath = AbstractCatalog.newTableLocation((String)this.path, (Identifier)identifier);
        new SchemaManager((FileIO)LocalFileIO.create(), tablePath).createTable(schema);
        String hiveSql = String.join((CharSequence)"\n", Arrays.asList("CREATE EXTERNAL TABLE " + tableName + " ", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "LOCATION '" + tablePath.toUri().toString() + "'"));
        Assertions.assertThatCode(() -> hiveShell.execute(hiveSql)).doesNotThrowAnyException();
        List result = hiveShell.executeQuery("SHOW CREATE TABLE " + tableName);
        Assertions.assertThat((List)result).containsAnyOf((Object[])new String[]{"CREATE EXTERNAL TABLE `with_paimon_table`(", "  `col1` int COMMENT 'first comment', ", "  `col2` string COMMENT 'second comment')", "ROW FORMAT SERDE ", "  'org.apache.paimon.hive.PaimonSerDe' ", "STORED BY ", "  'org.apache.paimon.hive.PaimonStorageHandler' "});
        hiveShell.execute("INSERT INTO " + tableName + " VALUES (1,'Hello'),(2,'Paimon')");
        result = hiveShell.executeQuery("SELECT col2, col1 FROM " + tableName);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"Hello\t1", "Paimon\t2"});
        result = hiveShell.executeQuery("SELECT col2 FROM " + tableName);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"Hello", "Paimon"});
        result = hiveShell.executeQuery("SELECT Col2 FROM " + tableName);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"Hello", "Paimon"});
        result = hiveShell.executeQuery("SELECT * FROM " + tableName + " WHERE col2 = 'Hello'");
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"1\tHello"});
        result = hiveShell.executeQuery("SELECT * FROM " + tableName + " WHERE Col2 in ('Hello', 'Paimon')");
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"1\tHello", "2\tPaimon"});
    }

    @Test
    public void testReadExternalTableWithDataAndIgnoreCase() throws Exception {
        String tableName = "with_data_and_ignore_case";
        Identifier identifier = Identifier.create((String)"test_db", (String)tableName);
        Options conf = new Options();
        conf.set(CatalogOptions.WAREHOUSE, (Object)this.path);
        conf.set(CoreOptions.BUCKET, (Object)2);
        conf.set(CoreOptions.FILE_FORMAT, (Object)CoreOptions.FileFormatType.AVRO);
        RowType.Builder rowType = RowType.builder();
        rowType.field("col1", (DataType)DataTypes.INT());
        rowType.field("Col2", (DataType)DataTypes.STRING());
        Table table = FileStoreTestUtils.createFileStoreTable(conf, rowType.build(), Collections.emptyList(), Collections.emptyList(), identifier);
        List<InternalRow> data = Arrays.asList(GenericRow.of((Object[])new Object[]{1, BinaryString.fromString((String)"Hello")}), GenericRow.of((Object[])new Object[]{2, BinaryString.fromString((String)"Paimon")}));
        StreamWriteBuilder streamWriteBuilder = table.newStreamWriteBuilder();
        StreamTableWrite write = streamWriteBuilder.newWrite();
        StreamTableCommit commit = streamWriteBuilder.newCommit();
        for (InternalRow rowData : data) {
            write.write(rowData);
        }
        commit.commit(0L, write.prepareCommit(true, 0L));
        write.close();
        commit.close();
        Path tablePath = AbstractCatalog.newTableLocation((String)this.path, (Identifier)identifier);
        SchemaManager schemaManager = new SchemaManager((FileIO)LocalFileIO.create(), tablePath);
        schemaManager.commitChanges(new SchemaChange[]{SchemaChange.addColumn((String)"N1", (DataType)DataTypes.STRING())});
        String hiveSql = String.join((CharSequence)"\n", Arrays.asList("CREATE EXTERNAL TABLE " + tableName + " ", "STORED BY '" + PaimonStorageHandler.class.getName() + "'", "LOCATION '" + tablePath.toUri().toString() + "'"));
        Assertions.assertThatCode(() -> hiveShell.execute(hiveSql)).doesNotThrowAnyException();
        List result = hiveShell.executeQuery("SELECT * FROM " + tableName + " WHERE col2 is not null");
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"1\tHello\tNULL", "2\tPaimon\tNULL"});
    }
}

