/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.mapred;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.hive.mapred.PaimonInputSplit;
import org.apache.paimon.io.DataFileTestDataGenerator;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class PaimonInputSplitTest {
    @TempDir
    java.nio.file.Path tempDir;

    @Test
    public void testWriteAndRead() throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        DataFileTestDataGenerator gen = DataFileTestDataGenerator.builder().numBuckets(1).build();
        ArrayList<DataFileTestDataGenerator.Data> generated = new ArrayList<DataFileTestDataGenerator.Data>();
        for (int i = random.nextInt(100) + 1; i > 0; --i) {
            generated.add(gen.next());
        }
        BinaryRow wantedPartition = ((DataFileTestDataGenerator.Data)generated.get((int)0)).partition;
        DataSplit dataSplit = DataSplit.builder().withSnapshot(ThreadLocalRandom.current().nextLong(100L)).withPartition(wantedPartition).withBucket(0).withDataFiles(generated.stream().filter(d -> d.partition.equals((Object)wantedPartition)).map(d -> d.meta).collect(Collectors.toList())).rawConvertible(false).withBucketPath("not used").build();
        PaimonInputSplit split = new PaimonInputSplit(this.tempDir.toString(), dataSplit, null);
        this.assertPaimonInputSplitSerialization(split);
    }

    private void assertPaimonInputSplitSerialization(PaimonInputSplit split) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        split.write((DataOutput)output);
        byte[] bytes = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream input = new DataInputStream(bais);
        PaimonInputSplit actual = new PaimonInputSplit();
        actual.readFields((DataInput)input);
        Assertions.assertThat((Object)actual).isEqualTo((Object)split);
    }

    @Test
    public void testWriteAndReadWithTable() throws Exception {
        Path path = new Path(this.tempDir.toString());
        SchemaManager schemaManager = new SchemaManager((FileIO)LocalFileIO.create(), path);
        schemaManager.createTable(new Schema(RowType.of((DataType[])new DataType[]{VarCharType.STRING_TYPE}).getFields(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), ""));
        FileStoreTable fileStoreTable = FileStoreTableFactory.create((FileIO)LocalFileIO.create(), (Path)path);
        this.writeData(fileStoreTable);
        DataSplit split = (DataSplit)fileStoreTable.newScan().plan().splits().get(0);
        PaimonInputSplit paimonInputSplit = new PaimonInputSplit(path.toString(), split, fileStoreTable);
        this.assertPaimonInputSplitSerialization(paimonInputSplit);
    }

    private void writeData(FileStoreTable fileStoreTable) throws Exception {
        String commitUser = UUID.randomUUID().toString();
        TableWriteImpl tableWrite = fileStoreTable.newWrite(commitUser);
        tableWrite.write((InternalRow)GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)"1111")}));
        TableCommitImpl commit = fileStoreTable.newCommit(commitUser);
        commit.commit(0L, tableWrite.prepareCommit(true, 0L));
        tableWrite.close();
        commit.close();
    }
}

