/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.time.LocalDate;
import java.util.Date;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.paimon.hive.objectinspector.PaimonDateObjectInspector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PaimonDateObjectInspectorTest {
    @Test
    public void testCategoryAndClass() {
        PaimonDateObjectInspector oi = new PaimonDateObjectInspector();
        Assertions.assertThat((Comparable)oi.getCategory()).isEqualTo((Object)ObjectInspector.Category.PRIMITIVE);
        Assertions.assertThat((Comparable)oi.getPrimitiveCategory()).isEqualTo((Object)PrimitiveObjectInspector.PrimitiveCategory.DATE);
        Assertions.assertThat((Class)oi.getJavaPrimitiveClass()).isEqualTo(java.sql.Date.class);
        Assertions.assertThat((Class)oi.getPrimitiveWritableClass()).isEqualTo(DateWritable.class);
    }

    @Test
    public void testGetPrimitiveJavaObject() {
        PaimonDateObjectInspector oi = new PaimonDateObjectInspector();
        int input = 375;
        Assertions.assertThat((String)oi.getPrimitiveJavaObject((Object)input).toString()).isEqualTo("1971-01-11");
        Assertions.assertThat((Date)oi.getPrimitiveJavaObject(null)).isNull();
    }

    @Test
    public void testGetPrimitiveWritableObject() {
        PaimonDateObjectInspector oi = new PaimonDateObjectInspector();
        int input = 375;
        Assertions.assertThat((String)oi.getPrimitiveWritableObject((Object)input).get().toString()).isEqualTo("1971-01-11");
        Assertions.assertThat((Comparable)oi.getPrimitiveWritableObject(null)).isNull();
    }

    @Test
    public void testCopyObject() {
        PaimonDateObjectInspector oi = new PaimonDateObjectInspector();
        java.sql.Date input = java.sql.Date.valueOf(LocalDate.ofEpochDay(375L));
        Object copy = oi.copyObject((Object)input);
        Assertions.assertThat((Object)copy).isEqualTo((Object)input);
        Assertions.assertThat((Object)copy).isNotSameAs((Object)input);
        Assertions.assertThat((Object)oi.copyObject((Object)375)).isEqualTo((Object)375);
        Assertions.assertThat((Object)oi.copyObject(null)).isNull();
    }
}

