/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.math.BigDecimal;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.hive.objectinspector.PaimonDecimalObjectInspector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PaimonDecimalObjectInspectorTest {
    @Test
    public void testCategoryAndClass() {
        PaimonDecimalObjectInspector oi = new PaimonDecimalObjectInspector(5, 3);
        Assertions.assertThat((Comparable)oi.getCategory()).isEqualTo((Object)ObjectInspector.Category.PRIMITIVE);
        Assertions.assertThat((Comparable)oi.getPrimitiveCategory()).isEqualTo((Object)PrimitiveObjectInspector.PrimitiveCategory.DECIMAL);
        Assertions.assertThat((Class)oi.getJavaPrimitiveClass()).isEqualTo(HiveDecimal.class);
        Assertions.assertThat((Class)oi.getPrimitiveWritableClass()).isEqualTo(HiveDecimalWritable.class);
    }

    @Test
    public void testGetPrimitiveJavaObject() {
        PaimonDecimalObjectInspector oi = new PaimonDecimalObjectInspector(5, 3);
        Decimal input = Decimal.fromBigDecimal((BigDecimal)new BigDecimal("12.345"), (int)5, (int)3);
        HiveDecimal expected = HiveDecimal.create((String)"12.345");
        Assertions.assertThat((Comparable)oi.getPrimitiveJavaObject((Object)input)).isEqualTo((Object)expected);
        Assertions.assertThat((Comparable)oi.getPrimitiveJavaObject(null)).isNull();
    }

    @Test
    public void testGetPrimitiveWritableObject() {
        PaimonDecimalObjectInspector oi = new PaimonDecimalObjectInspector(5, 3);
        Decimal input = Decimal.fromBigDecimal((BigDecimal)new BigDecimal("12.345"), (int)5, (int)3);
        HiveDecimalWritable expected = new HiveDecimalWritable(HiveDecimal.create((String)"12.345"));
        Assertions.assertThat((Comparable)oi.getPrimitiveWritableObject((Object)input)).isEqualTo((Object)expected);
        Assertions.assertThat((Comparable)oi.getPrimitiveWritableObject(null)).isNull();
    }

    @Test
    public void testCopyObject() {
        PaimonDecimalObjectInspector oi = new PaimonDecimalObjectInspector(5, 3);
        Decimal input1 = Decimal.fromBigDecimal((BigDecimal)new BigDecimal("12.345"), (int)5, (int)3);
        Object copy1 = oi.copyObject((Object)input1);
        Assertions.assertThat((Object)copy1).isEqualTo((Object)input1);
        Assertions.assertThat((Object)copy1).isNotSameAs((Object)input1);
        HiveDecimal input2 = HiveDecimal.create((String)"12.345");
        Object copy2 = oi.copyObject((Object)input2);
        Assertions.assertThat((Object)copy2).isEqualTo((Object)input2);
        Assertions.assertThat((Object)copy2).isNotSameAs((Object)input2);
        Assertions.assertThat((Object)oi.copyObject(null)).isNull();
    }
}

