/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.hive.objectinspector.PaimonVarcharObjectInspector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PaimonVarcharObjectInspectorTest {
    @Test
    public void testCategoryAndClass() {
        PaimonVarcharObjectInspector oi = new PaimonVarcharObjectInspector(10);
        Assertions.assertThat((Comparable)oi.getCategory()).isEqualTo((Object)ObjectInspector.Category.PRIMITIVE);
        Assertions.assertThat((Comparable)oi.getPrimitiveCategory()).isEqualTo((Object)PrimitiveObjectInspector.PrimitiveCategory.VARCHAR);
        Assertions.assertThat((Class)oi.getJavaPrimitiveClass()).isEqualTo(HiveVarchar.class);
        Assertions.assertThat((Class)oi.getPrimitiveWritableClass()).isEqualTo(HiveVarcharWritable.class);
    }

    @Test
    public void testGetPrimitiveJavaObject() {
        PaimonVarcharObjectInspector oi = new PaimonVarcharObjectInspector(10);
        BinaryString input1 = BinaryString.fromString((String)"testString");
        HiveVarchar expected1 = new HiveVarchar("testString", 10);
        BinaryString input2 = BinaryString.fromString((String)"test");
        HiveVarchar expected2 = new HiveVarchar("test", 10);
        Assertions.assertThat((Comparable)oi.getPrimitiveJavaObject((Object)input1)).isEqualTo((Object)expected1);
        Assertions.assertThat((Comparable)oi.getPrimitiveJavaObject((Object)input2)).isEqualTo((Object)expected2);
        Assertions.assertThat((Comparable)oi.getPrimitiveJavaObject(null)).isNull();
    }

    @Test
    public void testGetPrimitiveWritableObject() {
        PaimonVarcharObjectInspector oi = new PaimonVarcharObjectInspector(10);
        BinaryString input1 = BinaryString.fromString((String)"testString");
        HiveVarcharWritable expected1 = new HiveVarcharWritable(new HiveVarchar("testString", 10));
        BinaryString input2 = BinaryString.fromString((String)"test");
        HiveVarcharWritable expected2 = new HiveVarcharWritable(new HiveVarchar("test", 10));
        Assertions.assertThat((Comparable)oi.getPrimitiveWritableObject((Object)input1)).isEqualTo((Object)expected1);
        Assertions.assertThat((Comparable)oi.getPrimitiveWritableObject((Object)input2)).isEqualTo((Object)expected2);
        Assertions.assertThat((Comparable)oi.getPrimitiveWritableObject(null)).isNull();
    }

    @Test
    public void testCopyObject() {
        PaimonVarcharObjectInspector oi = new PaimonVarcharObjectInspector(10);
        BinaryString input1 = BinaryString.fromString((String)"testString");
        Object copy1 = oi.copyObject((Object)input1);
        Assertions.assertThat((Object)copy1).isEqualTo((Object)input1);
        Assertions.assertThat((Object)copy1).isNotSameAs((Object)input1);
        HiveVarchar input2 = new HiveVarchar("test", 10);
        Object copy2 = oi.copyObject((Object)input2);
        Assertions.assertThat((Object)copy2).isEqualTo((Object)input2);
        Assertions.assertThat((Object)copy2).isNotSameAs((Object)input2);
        Assertions.assertThat((Object)oi.copyObject(null)).isNull();
    }
}

