/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.runner;

import com.klarna.hiverunner.HiveServerContext;
import com.klarna.hiverunner.config.HiveRunnerConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.rules.TemporaryFolder;

public class PaimonEmbeddedHiveServerContext
implements HiveServerContext {
    private final HiveConf hiveConf = new HiveConf();
    private final TemporaryFolder basedir;
    private final HiveRunnerConfig hiveRunnerConfig;
    private boolean inited = false;

    PaimonEmbeddedHiveServerContext(TemporaryFolder basedir, HiveRunnerConfig hiveRunnerConfig) {
        this.basedir = basedir;
        this.hiveRunnerConfig = hiveRunnerConfig;
    }

    public final void init() {
        if (!this.inited) {
            this.configureMiscHiveSettings();
            this.configureMetaStore();
            this.configureMrExecutionEngine();
            this.configureJavaSecurityRealm();
            this.configureSupportConcurrency();
            this.configureFileSystem();
            this.configureAssertionStatus();
            this.overrideHiveConf();
            this.setHiveSitePath();
        }
        this.inited = true;
    }

    private void setHiveSitePath() {
        File hiveSite = new File(this.newFolder(this.basedir, "hive-conf"), "hive-site.xml");
        try (FileOutputStream outputStream = new FileOutputStream(hiveSite);){
            this.hiveConf.writeXml((OutputStream)outputStream);
            HiveConf.setHiveSiteLocation((URL)hiveSite.toURI().toURL());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write hive-site.xml", e);
        }
    }

    private void configureMiscHiveSettings() {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_CBO_ENABLED, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED, false);
        this.hiveConf.setVar(HiveConf.ConfVars.HADOOPBIN, "NO_BIN!");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVECHECKFILEFORMAT, false);
    }

    private void overrideHiveConf() {
        for (Map.Entry hiveConfEntry : this.hiveRunnerConfig.getHiveConfSystemOverride().entrySet()) {
            this.hiveConf.set((String)hiveConfEntry.getKey(), (String)hiveConfEntry.getValue());
        }
    }

    private void configureMrExecutionEngine() {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_INFER_BUCKET_SORT, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVEMETADATAONLYQUERIES, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVEOPTINDEXFILTER, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVESKEWJOIN, false);
        this.hiveConf.setLongVar(HiveConf.ConfVars.HIVECOUNTERSPULLINTERVAL, 1L);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_RPC_QUERY_PLAN, true);
    }

    private void configureJavaSecurityRealm() {
        System.setProperty("java.security.krb5.realm", "EXAMPLE.COM");
        System.setProperty("java.security.krb5.kdc", "kdc");
        System.setProperty("java.security.krb5.conf", "/dev/null");
    }

    private void configureAssertionStatus() {
        ClassLoader.getSystemClassLoader().setPackageAssertionStatus("org.apache.hadoop.hive.serde2.objectinspector", false);
    }

    private void configureSupportConcurrency() {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
    }

    private void configureMetaStore() {
        String jdbcDriver = EmbeddedDriver.class.getName();
        try {
            Class.forName(jdbcDriver);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        String jdoConnectionURL = "jdbc:derby:memory:" + UUID.randomUUID().toString();
        this.hiveConf.setVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, jdoConnectionURL + ";create=true");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.METASTORE_VALIDATE_CONSTRAINTS, true);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.METASTORE_VALIDATE_COLUMNS, true);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.METASTORE_VALIDATE_TABLES, true);
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hive.hcatalog.storagehandler.DummyHCatAuthProvider");
        this.hiveConf.set("hive.notification.event.poll.interval", "0s");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.METASTORE_DISALLOW_INCOMPATIBLE_COL_TYPE_CHANGES, false);
    }

    private void configureFileSystem() {
        this.createAndSetFolderProperty(HiveConf.ConfVars.METASTOREWAREHOUSE, "warehouse", this.hiveConf, this.basedir);
        this.createAndSetFolderProperty(HiveConf.ConfVars.SCRATCHDIR, "scratchdir", this.hiveConf, this.basedir);
        this.createAndSetFolderProperty(HiveConf.ConfVars.LOCALSCRATCHDIR, "localscratchdir", this.hiveConf, this.basedir);
        this.createAndSetFolderProperty(HiveConf.ConfVars.HIVEHISTORYFILELOC, "tmp", this.hiveConf, this.basedir);
        this.hiveConf.setBoolean("hive.warehouse.subdir.inherit.perms", true);
        this.createAndSetFolderProperty("hadoop.tmp.dir", "hadooptmp", this.hiveConf, this.basedir);
        this.createAndSetFolderProperty("test.log.dir", "logs", this.hiveConf, this.basedir);
    }

    private File newFolder(TemporaryFolder basedir, String folder) {
        try {
            File newFolder = basedir.newFolder(folder);
            FileUtil.setPermission((File)newFolder, (FsPermission)FsPermission.getDirDefault());
            return newFolder;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create tmp dir: " + e.getMessage(), e);
        }
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public TemporaryFolder getBaseDir() {
        return this.basedir;
    }

    private void createAndSetFolderProperty(HiveConf.ConfVars var, String folder, HiveConf conf, TemporaryFolder basedir) {
        conf.setVar(var, this.newFolder(basedir, folder).getAbsolutePath());
    }

    private void createAndSetFolderProperty(String key, String folder, HiveConf conf, TemporaryFolder basedir) {
        conf.set(key, this.newFolder(basedir, folder).getAbsolutePath());
    }
}

